/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.birt.component;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.eclipse.birt.data.engine.executor.cache.Md5Util;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.orienteer.birt.AbstractBirtHTMLImageHandler;
import org.orienteer.birt.BirtImage;
import org.orienteer.birt.Module;
import org.orienteer.birt.component.IBirtReportData;
import org.orienteer.birt.component.service.BirtReportParameterDefinition;
import org.orienteer.birt.component.service.IBirtReportConfig;
import org.orienteer.core.OrienteerWebApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ydn.wicket.wicketorientdb.OrientDbWebApplication;
import ru.ydn.wicket.wicketorientdb.OrientDbWebSession;

public abstract class AbstractBirtReportPanel
extends Panel
implements IPageable,
IBirtReportData,
IResourceListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBirtHTMLImageHandler.class);
    protected static final String REPORT_COMPONENT_NAME = "reportContent";
    protected static final String RESOURCE_IMAGE_ID = "imageId";
    protected static final String CACHE_EXTENCION = ".rptdocument";
    protected static final String CACHE_FOLDER = System.getProperty("java.io.tmpdir") + "/birt_cache";
    private long currentPage = 0L;
    private long pagesCount = 1L;
    private IBirtReportConfig config;
    private String reportHash;
    private List<BirtReportParameterDefinition> paramDefinitions;
    private List<BirtReportParameterDefinition> hiddenParamDefinitions;
    private AbstractBirtHTMLImageHandler imageHandler = new AbstractBirtHTMLImageHandler(){

        @Override
        protected String urlFor(String id, BirtImage image) {
            return AbstractBirtReportPanel.this.urlFor(IResourceListener.INTERFACE, new PageParameters().add(AbstractBirtReportPanel.RESOURCE_IMAGE_ID, (Object)id)).toString();
        }
    };

    public AbstractBirtReportPanel(String id, IBirtReportConfig config) throws EngineException {
        super(id);
        this.config = config;
        this.paramDefinitions = new ArrayList<BirtReportParameterDefinition>();
        this.hiddenParamDefinitions = new ArrayList<BirtReportParameterDefinition>();
        this.reportHash = this.makeReportHash();
        this.updateReportCache();
        Label reportComponent = new Label(REPORT_COMPONENT_NAME, (Serializable)((Object)""));
        reportComponent.setEscapeModelStrings(false);
        reportComponent.setOutputMarkupId(true);
        this.add(new Component[]{reportComponent});
    }

    public void onResourceRequested() {
        IResource resource;
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters params = requestCycle.getRequest().getRequestParameters();
        String imageId = params.getParameterValue(RESOURCE_IMAGE_ID).toOptionalString();
        if (imageId != null && (resource = this.imageHandler.getBirtImageAsResource(imageId)) != null) {
            resource.respond(new IResource.Attributes(requestCycle.getRequest(), requestCycle.getResponse(), null));
        }
    }

    @Override
    public IHTMLImageHandler getIHTMLImageHandler() {
        return this.imageHandler;
    }

    @Override
    public String getOutName() {
        return this.config.getOutName();
    }

    public Component getReportComponent() {
        return this.get(REPORT_COMPONENT_NAME);
    }

    private String makeReportHash() {
        return Md5Util.getMD5((String)("" + Math.random()));
    }

    public Object getParameter(String name) {
        return this.config.getParameters().get(name);
    }

    public Object setParameter(String name, Object value) {
        return this.config.getParameters().put(name, value);
    }

    private IReportDocument getReportCache(InputStream reportInputStream) throws EngineException {
        IReportEngine engine = this.getReportEngine();
        IReportRunnable design = engine.openReportDesign(reportInputStream);
        if (this.isUseLocalDB()) {
            AbstractBirtReportPanel.updateDBUriToLocal(design);
        }
        this.updateParametersDefinitions(design);
        IRunTask runTask = engine.createRunTask(design);
        runTask.setParameterValues(this.config.getParameters());
        runTask.run(this.getReportCachePath());
        runTask.close();
        IReportDocument cache = engine.openReportDocument(this.getReportCachePath());
        return cache;
    }

    public void updateReportCache() throws EngineException {
        IReportDocument cache = this.getReportCache(this.getConfig().getReportDataStream());
        this.pagesCount = cache.getPageCount();
        cache.close();
    }

    public List<BirtReportParameterDefinition> getParametersDefenitions() {
        return this.paramDefinitions;
    }

    public List<BirtReportParameterDefinition> getHiddenParametersDefinitions() {
        return this.hiddenParamDefinitions;
    }

    private static void updateDBUriToLocal(IReportRunnable design) {
        ReportDesignHandle handle = (ReportDesignHandle)design.getDesignHandle();
        SlotHandle datasources = handle.getDataSources();
        for (DesignElementHandle dsHandle : datasources) {
            OdaDataSourceHandle odash;
            if (!(dsHandle instanceof OdaDataSourceHandle) || !(odash = (OdaDataSourceHandle)dsHandle).getExtensionID().equals("org.orienteer.birt.orientdb")) continue;
            try {
                odash.setProperty("uri", (Object)OrientDbWebApplication.get().getOrientDbSettings().getDBUrl());
                odash.setProperty("user", (Object)OrientDbWebSession.get().getUsername());
                odash.setProperty("password", (Object)OrientDbWebSession.get().getPassword());
            }
            catch (SemanticException e) {
                LOG.error("Cen't part BIRT xml file", (Throwable)e);
            }
        }
    }

    private void updateParametersDefinitions(IReportRunnable design) {
        IGetParameterDefinitionTask paramTask = this.getReportEngine().createGetParameterDefinitionTask(design);
        Set<Object> visibleParams = this.getConfig().getVisibleParameters();
        if (visibleParams != null) {
            for (Object object : visibleParams) {
                IParameterDefnBase iParameterDefnBase = paramTask.getParameterDefn((String)object);
                this.paramDefinitions.add(new BirtReportParameterDefinition(iParameterDefnBase));
            }
        }
        Collection defs = paramTask.getParameterDefns(false);
        for (IParameterDefnBase iParameterDefnBase : defs) {
            if (visibleParams != null && visibleParams.contains(iParameterDefnBase.getName())) continue;
            this.hiddenParamDefinitions.add(new BirtReportParameterDefinition(iParameterDefnBase));
        }
    }

    @Override
    public IReportDocument getReportCache() throws EngineException {
        return this.getReportEngine().openReportDocument(this.getReportCachePath());
    }

    public String getReportCachePath() {
        OrientDbWebSession session = OrientDbWebSession.get();
        String path = CACHE_FOLDER + "/" + session.getUsername() + "/" + session.getId() + "/" + this.reportHash + CACHE_EXTENCION;
        return path;
    }

    @Override
    public IReportEngine getReportEngine() {
        Module module = (Module)OrienteerWebApplication.get().getModuleByName("orienteer-birt");
        return module.getEngine();
    }

    private void updateReportOut() throws EngineException {
        String out;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        IReportDocument cache = this.getReportCache();
        IRenderTask renderTask = this.getReportEngine().createRenderTask(cache);
        IRenderOption options = this.makeRenderOption();
        options.setOutputStream((OutputStream)buf);
        options.setImageHandler((IHTMLImageHandler)this.imageHandler);
        renderTask.setRenderOption(options);
        renderTask.setPageNumber(this.currentPage + 1L);
        renderTask.render();
        cache.close();
        try {
            out = buf.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Encoding is not supported", (Throwable)e);
            out = buf.toString();
        }
        this.get(REPORT_COMPONENT_NAME).setDefaultModelObject((Object)out);
    }

    protected void onBeforeRender() {
        try {
            this.updateReportOut();
        }
        catch (EngineException e) {
            LOG.error("Can't update report output", (Throwable)e);
        }
        super.onBeforeRender();
    }

    protected abstract IRenderOption makeRenderOption();

    public long getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(long page) {
        this.currentPage = page;
    }

    public long getPageCount() {
        return this.pagesCount;
    }

    public boolean isUseLocalDB() {
        return this.config.isUseLocalDB();
    }

    public IBirtReportConfig getConfig() {
        return this.config;
    }
}

