/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.birt.component;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.ResourceLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.resource.IResource;
import org.eclipse.birt.report.engine.api.EngineException;
import org.orienteer.birt.component.AbstractBirtReportPanel;
import org.orienteer.birt.component.resources.ExcelBirtResource;
import org.orienteer.birt.component.resources.HtmlBirtResource;
import org.orienteer.birt.component.resources.PDFBirtResource;
import org.orienteer.birt.component.service.BirtReportParameterDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BirtManagementPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(BirtManagementPanel.class);
    private static final String PAGER_NAME = "paginator";

    public BirtManagementPanel(String id, final AbstractBirtReportPanel reportPanel) {
        super(id);
        AjaxPagingNavigator pager = new AjaxPagingNavigator(PAGER_NAME, reportPanel){
            private static final long serialVersionUID = 1L;

            protected void onAjaxEvent(AjaxRequestTarget target) {
                target.add(new Component[]{reportPanel});
                target.add(new Component[]{this});
            }
        };
        this.add(new Component[]{pager});
        this.add(new Component[]{new ResourceLink("HTML", (IResource)new HtmlBirtResource(reportPanel))});
        this.add(new Component[]{new ResourceLink("PDF", (IResource)new PDFBirtResource(reportPanel))});
        this.add(new Component[]{new ResourceLink("Excel", (IResource)new ExcelBirtResource(reportPanel))});
        this.add(new Component[]{new ParamsListView("params", reportPanel.getParametersDefenitions(), reportPanel, (Component)pager)});
        this.add(new Component[]{new ParamsListView("hiddenParams", reportPanel.getHiddenParametersDefinitions(), reportPanel, (Component)pager)});
    }

    private class ParamsListView
    extends ListView<BirtReportParameterDefinition> {
        private static final long serialVersionUID = 1L;
        private AbstractBirtReportPanel reportPanel;
        private Component pager;

        public ParamsListView(String id, List<BirtReportParameterDefinition> list, AbstractBirtReportPanel reportPanel, Component pager) {
            super(id, list);
            this.reportPanel = reportPanel;
            this.pager = pager;
        }

        protected void populateItem(ListItem<BirtReportParameterDefinition> item) {
            String name = ((BirtReportParameterDefinition)item.getModelObject()).getName();
            item.add(new Component[]{new Label("parameterName", (Serializable)((Object)name))});
            String defaultValue = ((BirtReportParameterDefinition)item.getModelObject()).getDefaultValue();
            Object value = this.reportPanel.getParameter(name);
            if (Strings.isNullOrEmpty((String)((String)value))) {
                this.reportPanel.setParameter(name, defaultValue);
            }
            item.add(new Component[]{new TextField("parameterInput", (IModel)new PropertyModel((Object)this.reportPanel, "config.parameters[" + name + "]")).add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    try {
                        ParamsListView.this.reportPanel.setCurrentPage(0L);
                        ParamsListView.this.reportPanel.updateReportCache();
                        target.add(new Component[]{ParamsListView.this.reportPanel});
                        target.add(new Component[]{ParamsListView.this.pager});
                    }
                    catch (EngineException e) {
                        String message = e.getMessage();
                        ParamsListView.this.error((Serializable)((Object)("Cannot update report cache:" + message)));
                        LOG.error("Can't update report cache", (Throwable)e);
                    }
                }
            }})});
        }
    }
}

