/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.birt;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.io.IClusterable;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.orienteer.birt.BirtImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBirtHTMLImageHandler
implements IHTMLImageHandler,
IClusterable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBirtHTMLImageHandler.class);
    private Map<String, BirtImage> imageMap = new HashMap<String, BirtImage>();

    public String onDesignImage(IImage image, IReportContext context) {
        return this.handleImage(image, context);
    }

    public String onDocImage(IImage image, IReportContext context) {
        return this.handleImage(image, context);
    }

    public String onFileImage(IImage image, IReportContext context) {
        return this.handleImage(image, context);
    }

    public String onURLImage(IImage image, IReportContext context) {
        return this.handleImage(image, context);
    }

    public String onCustomImage(IImage image, IReportContext context) {
        return this.handleImage(image, context);
    }

    protected String handleImage(IImage image, IReportContext context) {
        BirtImage birtImage = this.getCachedImage(image.getID(), image.getSource(), context);
        if (birtImage == null) {
            birtImage = new BirtImage(image);
            if (birtImage.getURL() == null) {
                birtImage.setURL(this.urlFor(birtImage.getID(), birtImage));
            }
            this.imageMap.put(image.getID(), birtImage);
        }
        return birtImage.getURL();
    }

    protected abstract String urlFor(String var1, BirtImage var2);

    public BirtImage getBirtImage(String id) {
        return this.imageMap.get(id);
    }

    public IResource getBirtImageAsResource(String id) {
        BirtImage image = this.imageMap.get(id);
        return image != null ? image.toResource() : null;
    }

    public BirtImage getCachedImage(String id, int type, IReportContext context) {
        return null;
    }

    public BirtImage addCachedImage(String id, int type, IImage image, IReportContext context) {
        return null;
    }

    public String onDesignImage(IImage image, Object context) {
        throw new UnsupportedOperationException("Method onDesignImage(IImage image, Object context) is not supported");
    }

    public String onDocImage(IImage image, Object context) {
        throw new UnsupportedOperationException("Method onDocImage(IImage image, Object context) is not supported");
    }

    public String onFileImage(IImage image, Object context) {
        throw new UnsupportedOperationException("Method onFileImage(IImage image, Object context) is not supported");
    }

    public String onURLImage(IImage image, Object context) {
        throw new UnsupportedOperationException("Method onURLImage(IImage image, Object context) is not supported");
    }

    public String onCustomImage(IImage image, Object context) {
        throw new UnsupportedOperationException("Method onCustomImage(IImage image, Object context) is not supported");
    }
}

