/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.birt;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.resource.UrlResourceStream;
import org.apache.wicket.request.resource.ByteArrayResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceStreamResource;
import org.apache.wicket.resource.FileSystemResource;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.resource.IResourceStream;
import org.eclipse.birt.report.engine.api.CachedImage;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.ImageSize;
import org.eclipse.birt.report.engine.util.FileUtil;

public class BirtImage
extends CachedImage
implements IClusterable {
    private int source;
    private byte[] data;

    public BirtImage(IImage image) {
        this.setID(image.getID());
        this.setImageMap(image.getImageMap());
        this.setImageSize(image.getImageSize());
        this.setMIMEType(image.getMimeType());
        this.setSource(image.getSource());
        this.setData(image.getImageData());
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public IResource toResource() {
        try {
            if (this.source == 2) {
                return new ResourceStreamResource((IResourceStream)new UrlResourceStream(new URL(this.getID())));
            }
            if (this.source == 3) {
                return new FileSystemResource(Paths.get(FileUtil.getURI((String)this.getID()), new String[0]));
            }
            return new ByteArrayResource(this.getMIMEType(), this.data);
        }
        catch (MalformedURLException e) {
            throw new WicketRuntimeException("Can't transform to resource", (Throwable)e);
        }
    }

    public void setImageSize(ImageSize size) {
        super.setImageSize((ImageSize)(size == null || size instanceof BirtImageSize ? size : new BirtImageSize(size)));
    }

    public static class BirtImageSize
    extends ImageSize
    implements IClusterable {
        public BirtImageSize(String u, float w, float h) {
            super(u, w, h);
        }

        public BirtImageSize(ImageSize imageSize) {
            super(imageSize.getUnit(), imageSize.getWidth(), imageSize.getHeight());
        }
    }
}

