/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.birt;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.logging.Level;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.core.internal.registry.RegistryProviderFactory;
import org.orienteer.core.OClassDomain;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.module.AbstractOrienteerModule;
import org.orienteer.core.util.OSchemaHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Module
extends AbstractOrienteerModule {
    public static final String LOGS_PATH = System.getProperty("java.io.tmpdir") + "/birt_logs";
    public static final String MODULE_NAME = "orienteer-birt";
    private static final Logger LOG = LoggerFactory.getLogger(Module.class);
    private IReportEngine engine;

    protected Module() {
        super(MODULE_NAME, 1, new String[]{"widgets"});
    }

    public ODocument onInstall(OrienteerWebApplication app, ODatabaseDocument db) {
        super.onInstall(app, db);
        this.makeSchema(db);
        return null;
    }

    public void onUpdate(OrienteerWebApplication app, ODatabaseDocument db, int oldVersion, int newVersion) {
        this.makeSchema(db);
        super.onUpdate(app, db, oldVersion, newVersion);
    }

    private void makeSchema(ODatabaseDocument db) {
        OSchemaHelper helper = OSchemaHelper.bind((ODatabaseDocument)db);
        helper.oClass("BirtWidget", new String[]{"OWidget"}).domain(OClassDomain.SYSTEM).oProperty("report", OType.BINARY, 100).oProperty("parameters", OType.EMBEDDEDMAP, 110).linkedType(OType.STRING).oProperty("useLocalDB", OType.BOOLEAN, 120).oProperty("visibleParameters", OType.EMBEDDEDSET, 130).linkedType(OType.STRING);
        helper.oClass("BrowseBirtWidget", new String[]{"BirtWidget"}).domain(OClassDomain.SYSTEM);
        helper.oClass("ODocumentBirtWidget", new String[]{"BirtWidget"}).domain(OClassDomain.SYSTEM);
    }

    public void onInitialize(OrienteerWebApplication app, ODatabaseDocument db) {
        super.onInitialize(app, db);
        app.mountPages("org.orienteer.birt.web");
        app.registerWidgets("org.orienteer.birt.component.widget");
        try {
            EngineConfig config = new EngineConfig();
            config.setLogConfig(LOGS_PATH, Level.FINE);
            Platform.startup((PlatformConfig)config);
            IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
            this.engine = factory.createReportEngine(config);
            this.engine.changeLogLevel(Level.WARNING);
        }
        catch (Exception ex) {
            LOG.error("Can't initialize BIRT module", (Throwable)ex);
        }
    }

    public void onDestroy(OrienteerWebApplication app, ODatabaseDocument db) {
        super.onDestroy(app, db);
        app.unmountPages("org.orienteer.birt.web");
        app.unregisterWidgets("org.orienteer.birt.component.widget");
        try {
            if (this.engine != null) {
                this.engine.destroy();
            }
            Platform.shutdown();
            RegistryProviderFactory.releaseDefault();
        }
        catch (Exception e1) {
            LOG.error("Can't destroy BIRT module", (Throwable)e1);
        }
    }

    public IReportEngine getEngine() {
        return this.engine;
    }
}

