/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.birt.component.resources;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.orienteer.birt.component.IBirtReportData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBirtResource
extends AbstractResource {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBirtResource.class);
    private IBirtReportData reportData;

    public AbstractBirtResource(IBirtReportData reportData) {
        this.reportData = reportData;
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
        this.setResourceData(resourceResponse);
        resourceResponse.setWriteCallback(new AbstractResource.WriteCallback(){

            public void writeData(IResource.Attributes attributes) throws IOException {
                try {
                    IReportDocument cache = AbstractBirtResource.this.reportData.getReportCache();
                    IRenderTask renderTask = AbstractBirtResource.this.reportData.getReportEngine().createRenderTask(cache);
                    OutputStream outputStream = attributes.getResponse().getOutputStream();
                    renderTask.setRenderOption(AbstractBirtResource.this.getRenderOptions(outputStream));
                    renderTask.render();
                    cache.close();
                }
                catch (EngineException e) {
                    LOG.error("BIRT report generation failed", (Throwable)e);
                }
            }
        });
        return resourceResponse;
    }

    protected abstract IRenderOption getRenderOptions(OutputStream var1);

    protected abstract void setResourceData(AbstractResource.ResourceResponse var1);

    public IBirtReportData getReportData() {
        return this.reportData;
    }
}

