/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.birt.component.service;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;
import org.eclipse.birt.report.engine.api.EngineException;
import org.orienteer.birt.component.service.IBirtReportConfig;

public class BirtReportODocumentConfig
implements IBirtReportConfig {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> parameters;
    private Set<Object> visibleParameters;
    private boolean useLocalDB;
    private IModel<ODocument> configDocModel;

    public BirtReportODocumentConfig(IModel<ODocument> configDocModel, Map<String, Object> additionalParameters) throws EngineException {
        Boolean isUseLocalDB;
        ODocument modelObject = (ODocument)configDocModel.getObject();
        byte[] reportData = (byte[])modelObject.field("report");
        if (reportData == null || reportData.length == 0) {
            throw new EngineException("Configure report first");
        }
        Map parameters = (Map)modelObject.field("parameters");
        if (additionalParameters != null) {
            parameters.putAll(additionalParameters);
        }
        if ((isUseLocalDB = (Boolean)modelObject.field("useLocalDB")) == null) {
            isUseLocalDB = false;
        }
        Set visibleParameters = (Set)modelObject.field("visibleParameters");
        this.configDocModel = configDocModel;
        this.parameters = parameters;
        this.visibleParameters = visibleParameters;
        this.useLocalDB = isUseLocalDB;
    }

    @Override
    public InputStream getReportDataStream() {
        return new ByteArrayInputStream((byte[])((ODocument)this.configDocModel.getObject()).field("report"));
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isUseLocalDB() {
        return this.useLocalDB;
    }

    @Override
    public Set<Object> getVisibleParameters() {
        return this.visibleParameters;
    }

    @Override
    public String getOutName() {
        ODocument modelObject = (ODocument)this.configDocModel.getObject();
        String filename = (String)modelObject.field("report$fileName");
        return Strings.isEmpty((CharSequence)filename) ? "report" : filename.replaceFirst("\\.[^\\.]*$", "");
    }
}

