/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.birt.component.widget;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.Serializable;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.ajax.markup.html.AjaxLazyLoadPanel;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.string.Strings;
import org.eclipse.birt.report.engine.api.EngineException;
import org.orienteer.birt.component.BirtManagedHtmlReportPanel;
import org.orienteer.birt.component.service.BirtReportODocumentConfig;
import org.orienteer.core.component.FAIcon;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.widget.AbstractWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractBirtWidget<T>
extends AbstractWidget<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBirtWidget.class);
    public static final String OCLASS_NAME = "BirtWidget";
    public static final String PARAMETERS_FIELD_NAME = "parameters";
    public static final String REPORT_FIELD_NAME = "report";
    public static final String USE_LOCAL_BASE_FIELD_NAME = "useLocalDB";
    public static final String VISIBLE_PARAMETERS_FIELD_NAME = "visibleParameters";

    public AbstractBirtWidget(String id, IModel<T> model, IModel<ODocument> widgetDocumentModel, final Map<String, Object> additionalParameters) {
        super(id, model, widgetDocumentModel);
        AjaxLazyLoadPanel panel = new AjaxLazyLoadPanel("reportHolder"){
            private static final long serialVersionUID = 1L;

            public Component getLazyLoadComponent(String id) {
                try {
                    return new BirtManagedHtmlReportPanel(id, new BirtReportODocumentConfig((IModel<ODocument>)AbstractBirtWidget.this.getWidgetDocumentModel(), additionalParameters));
                }
                catch (EngineException e) {
                    String message = e.getMessage();
                    if (!Strings.isEmpty((CharSequence)message)) {
                        this.error((Serializable)((Object)message));
                    }
                    LOG.error("BIRT HTML report panel can't be added", (Throwable)e);
                    return new Label(id, (Serializable)((Object)("Report error: " + message)));
                }
            }
        };
        this.add(new Component[]{panel});
    }

    protected FAIcon newIcon(String id) {
        return new FAIcon(id, FAIconType.table);
    }

    protected IModel<String> getDefaultTitleModel() {
        return new ResourceModel("widget.birt");
    }
}

