/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.db.AbstractPersistenceSession;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.orienteer.bpm.camunda.OProcessEngineConfiguration;
import org.orienteer.bpm.camunda.handler.HandlersManager;
import org.orienteer.bpm.camunda.handler.IEntityHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPersistenceSession
extends AbstractPersistenceSession {
    private static final Logger LOG = LoggerFactory.getLogger(OPersistenceSession.class);
    private ODatabaseDocumentTx db;
    private BiMap<String, OIdentifiable> idToOIdentifiableCache = HashBiMap.create((int)10);
    private Map<String, DbEntity> entitiesCache = new HashMap<String, DbEntity>();

    public OPersistenceSession(ODatabaseDocumentTx db) {
        this.db = db;
    }

    public static void staticInit(OProcessEngineConfiguration config) {
    }

    public ODatabaseDocumentTx getDatabase() {
        return this.db;
    }

    public OSchema getSchema() {
        return this.db.getMetadata().getSchema();
    }

    public OClass getClass(String className) {
        return this.getSchema().getClass(className);
    }

    public void fireEntityLoaded(ODocument sourceDoc, Object object, boolean hasNeedInCache) {
        super.fireEntityLoaded(object);
        if (object instanceof DbEntity) {
            DbEntity entity = (DbEntity)object;
            this.cacheODocument(sourceDoc);
            if (hasNeedInCache) {
                this.entitiesCache.put((String)sourceDoc.field("id"), entity);
            }
        }
    }

    public void cacheODocument(ODocument doc) {
        ORID orid = doc.getIdentity();
        this.idToOIdentifiableCache.put((Object)((String)doc.field("id")), (Object)orid);
    }

    public OIdentifiable lookupOIdentifiableForIdInCache(String oid) {
        return (OIdentifiable)this.idToOIdentifiableCache.get((Object)oid);
    }

    public DbEntity lookupEntityInCache(String oid) {
        return this.entitiesCache.get(oid);
    }

    public List<?> selectList(String statement, Object parameter) {
        this.db.activateOnCurrentThread();
        IEntityHandler handler = HandlersManager.get().getHandlerSafe(statement);
        if (handler != null) {
            return handler.selectList(statement, parameter, this);
        }
        LOG.error("Handler 'selectList' for statement '" + statement + "' was not found");
        return new ArrayList();
    }

    public <T extends DbEntity> T selectById(Class<T> type, String id) {
        this.db.activateOnCurrentThread();
        return HandlersManager.get().getHandler(type).read(id, this);
    }

    public Object selectOne(String statement, Object parameter) {
        this.db.activateOnCurrentThread();
        IEntityHandler handler = HandlersManager.get().getHandlerSafe(statement);
        if (handler != null) {
            return handler.selectOne(statement, parameter, this);
        }
        LOG.error("Handler 'selectOne' for statement '" + statement + "' was not found");
        return null;
    }

    public void lock(String statement, Object parameter) {
        this.db.activateOnCurrentThread();
        IEntityHandler handler = HandlersManager.get().getHandlerSafe(statement);
        if (handler != null) {
            handler.lock(statement, parameter, this);
        } else {
            LOG.error("Handler 'lock' for statement '" + statement + "' was not found");
        }
    }

    public void commit() {
        this.db.commit();
    }

    public void rollback() {
        this.db.rollback();
    }

    public void dbSchemaCheckVersion() {
    }

    public void flush() {
    }

    public void close() {
        this.db.close();
        this.db = null;
    }

    protected void insertEntity(DbEntityOperation operation) {
        this.db.activateOnCurrentThread();
        HandlersManager.get().getHandler(operation.getEntityType()).create(operation.getEntity(), this);
    }

    protected void deleteEntity(DbEntityOperation operation) {
        this.db.activateOnCurrentThread();
        HandlersManager.get().getHandler(operation.getEntityType()).delete(operation.getEntity(), this);
    }

    protected void deleteBulk(DbBulkOperation operation) {
        this.db.activateOnCurrentThread();
        IEntityHandler handler = HandlersManager.get().getHandlerSafe(operation.getStatement());
        if (handler != null) {
            handler.deleteBulk(operation, this);
        } else {
            LOG.error("Handler 'deleteBulk' for statement '" + operation.getStatement() + "' was not found");
        }
    }

    protected void updateEntity(DbEntityOperation operation) {
        this.db.activateOnCurrentThread();
        HandlersManager.get().getHandler(operation.getEntityType()).update(operation.getEntity(), this);
    }

    protected void updateBulk(DbBulkOperation operation) {
        this.db.activateOnCurrentThread();
        IEntityHandler handler = HandlersManager.get().getHandlerSafe(operation.getStatement());
        if (handler != null) {
            handler.updateBulk(operation, this);
        } else {
            LOG.error("Handler 'updateBulk' for statement '" + operation.getStatement() + "' was not found");
        }
    }

    protected String getDbVersion() {
        return "OrientDB";
    }

    protected void dbSchemaCreateIdentity() {
    }

    protected void dbSchemaCreateHistory() {
    }

    protected void dbSchemaCreateEngine() {
    }

    protected void dbSchemaCreateCmmn() {
    }

    protected void dbSchemaCreateCmmnHistory() {
    }

    protected void dbSchemaCreateDmn() {
    }

    protected void dbSchemaCreateDmnHistory() {
    }

    protected void dbSchemaDropIdentity() {
    }

    protected void dbSchemaDropHistory() {
    }

    protected void dbSchemaDropEngine() {
    }

    protected void dbSchemaDropCmmn() {
    }

    protected void dbSchemaDropCmmnHistory() {
    }

    protected void dbSchemaDropDmn() {
    }

    protected void dbSchemaDropDmnHistory() {
    }

    public boolean isEngineTablePresent() {
        return true;
    }

    public boolean isHistoryTablePresent() {
        return false;
    }

    public boolean isIdentityTablePresent() {
        return true;
    }

    public boolean isCmmnTablePresent() {
        return false;
    }

    public boolean isCmmnHistoryTablePresent() {
        return false;
    }

    public boolean isDmnTablePresent() {
        return false;
    }

    public boolean isDmnHistoryTablePresent() {
        return false;
    }
}

