/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.github.raymanrt.orientqb.query.Clause;
import com.github.raymanrt.orientqb.query.Operator;
import com.github.raymanrt.orientqb.query.Parameter;
import com.github.raymanrt.orientqb.query.core.AbstractQuery;
import com.gitub.raymanrt.orientqb.delete.Delete;
import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.core.util.lang.PropertyResolverConverter;
import org.apache.wicket.util.string.Strings;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.camunda.bpm.engine.query.Query;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.HandlersManager;
import org.orienteer.bpm.camunda.handler.IEntityHandler;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.util.OSchemaHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public abstract class AbstractEntityHandler<T extends DbEntity>
implements IEntityHandler<T> {
    private static final PropertyResolverConverter PROPERTY_RESOLVER_CONVERTEER = new PropertyResolverConverter(OrienteerWebApplication.lookupApplication().getConverterLocator(), Locale.getDefault());
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TypeToken<T> type = new TypeToken<T>(this.getClass()){};
    private final String schemaClass;
    private final String pkField;
    protected Map<String, String> mappingFromEntityToDoc;
    protected Map<String, String> mappingFromDocToEntity;
    protected Map<String, String> mappingFromQueryToDoc = new HashMap<String, String>();
    protected Map<String, Converter<Object, Object>> mappingConvertors = new HashMap<String, Converter<Object, Object>>();
    private Map<String, Method> statementMethodsMapping = new HashMap<String, Method>();

    public AbstractEntityHandler(String schemaClass) {
        this(schemaClass, "id");
    }

    public AbstractEntityHandler(String schemaClass, String pkField) {
        this.schemaClass = schemaClass;
        this.pkField = pkField;
        for (Method method : this.getClass().getMethods()) {
            Statement statement = method.getAnnotation(Statement.class);
            if (statement == null) continue;
            String st = statement.value();
            if (Strings.isEmpty((CharSequence)st)) {
                st = method.getName();
            }
            this.statementMethodsMapping.put(st, method);
        }
    }

    @Override
    public Class<T> getEntityClass() {
        return this.type.getRawType();
    }

    @Override
    public String getSchemaClass() {
        return this.schemaClass;
    }

    @Override
    public String getPkField() {
        return this.pkField;
    }

    @Override
    public void create(T entity, OPersistenceSession session) {
        ODocument doc = this.mapToODocument(entity, null, session);
        session.getDatabase().save((ORecord)doc);
        session.cacheODocument(doc);
    }

    @Override
    public T read(String id, OPersistenceSession session) {
        ODocument doc = this.readAsDocument(id, session);
        return doc == null ? null : this.mapToEntity(doc, null, session);
    }

    @Override
    public ODocument readAsDocument(String id, OPersistenceSession session) {
        String oid = (String)this.convertValueFromEntity("id", id);
        OIdentifiable oIdentifiable = session.lookupOIdentifiableForIdInCache(oid);
        if (oIdentifiable != null) {
            return (ODocument)oIdentifiable.getRecord();
        }
        ODatabaseDocumentTx db = session.getDatabase();
        List ret = db.query((OQuery)new OSQLSynchQuery("select from " + this.getSchemaClass() + " where " + this.getPkField() + " = ?", 1), new Object[]{oid});
        return ret == null || ret.isEmpty() ? null : (ODocument)ret.get(0);
    }

    @Override
    public void update(T entity, OPersistenceSession session) {
        ODocument doc = this.readAsDocument(entity.getId(), session);
        this.mapToODocument(entity, doc, session);
        session.getDatabase().save((ORecord)doc);
    }

    @Override
    public void delete(T entity, OPersistenceSession session) {
        ODatabaseDocumentTx db = session.getDatabase();
        String id = entity.getId();
        String oid = (String)this.convertValueFromEntity("id", id);
        OIdentifiable oIdentifiable = session.lookupOIdentifiableForIdInCache(oid);
        if (oIdentifiable != null) {
            db.delete(oIdentifiable.getIdentity());
        } else {
            db.command((OCommandRequest)new OCommandSQL("delete from " + this.getSchemaClass() + " where " + this.getPkField() + " = ?")).execute(new Object[]{oid});
        }
    }

    protected void checkMapping(OPersistenceSession session) {
        if ((this.mappingFromDocToEntity == null || this.mappingFromEntityToDoc == null) && session != null) {
            this.initMapping(session);
        }
    }

    protected PropertyResolver.IGetAndSet getGetAndSetter(Class<?> clazz, String property) {
        return PropertyResolver.getLocator().get(clazz, property);
    }

    protected void initMapping(OPersistenceSession session) {
        this.mappingFromDocToEntity = new HashMap<String, String>();
        this.mappingFromEntityToDoc = new HashMap<String, String>();
        OClass oClass = session.getClass(this.getSchemaClass());
        Class<T> entityClass = this.getEntityClass();
        for (OProperty property : oClass.properties()) {
            PropertyResolver.IGetAndSet getAndSet;
            String propertyName;
            String beanPropertyName = propertyName = property.getName();
            boolean isLink = property.getType().isLink();
            if (isLink) {
                beanPropertyName = beanPropertyName + "Id";
            }
            if ((getAndSet = this.getGetAndSetter(entityClass, beanPropertyName)) == null) continue;
            if (isLink) {
                Object targetHandler = HandlersManager.get().getHandlerBySchemaClass(property.getLinkedClass().getName());
                if (targetHandler == null || targetHandler.getPkField() == null) continue;
                propertyName = propertyName + "." + targetHandler.getPkField();
            }
            if (getAndSet.getSetter() != null) {
                this.mappingFromDocToEntity.put(propertyName, beanPropertyName);
            }
            if (getAndSet.getGetter() == null) continue;
            this.mappingFromEntityToDoc.put(beanPropertyName, propertyName);
        }
    }

    protected Object convertValueToEntity(String entityFieldName, Object value) {
        Converter<Object, Object> converter = this.mappingConvertors.get(entityFieldName);
        return converter == null ? value : converter.reverse().convert(value);
    }

    protected Object convertValueFromEntity(String entityFieldName, Object value) {
        Converter<Object, Object> converter = this.mappingConvertors.get(entityFieldName);
        return converter == null ? value : converter.convert(value);
    }

    @Override
    public T mapToEntity(ODocument doc, T entity, OPersistenceSession session) {
        this.checkMapping(session);
        try {
            if (this.hasNeedInCache() && session != null && (entity = session.lookupEntityInCache((String)doc.field(this.getPkField()))) != null) {
                return (T)entity;
            }
            if (entity == null) {
                entity = (DbEntity)this.getEntityClass().newInstance();
            }
            for (Map.Entry<String, String> mapToEntity : this.mappingFromDocToEntity.entrySet()) {
                Object valueToSet = doc.field(mapToEntity.getKey());
                valueToSet = this.convertValueToEntity(mapToEntity.getValue(), valueToSet);
                if (valueToSet != null) {
                    PropertyResolver.setValue((String)mapToEntity.getValue(), (Object)entity, (Object)valueToSet, (PropertyResolverConverter)PROPERTY_RESOLVER_CONVERTEER);
                    continue;
                }
                PropertyResolver.IGetAndSet getAndSet = this.getGetAndSetter(entity.getClass(), mapToEntity.getValue());
                if (getAndSet.getTargetClass().isPrimitive()) continue;
                getAndSet.setValue(entity, null, PROPERTY_RESOLVER_CONVERTEER);
            }
            if (entity instanceof HasDbRevision) {
                ((HasDbRevision)entity).setRevision(doc.getVersion());
            }
            if (session != null) {
                session.fireEntityLoaded(doc, entity, this.hasNeedInCache());
            }
            return (T)entity;
        }
        catch (Exception e) {
            this.logger.error("There shouldn't be this exception in case of predefined mapping", (Throwable)e);
            throw new IllegalStateException("There shouldn't be this exception in case of predefined mapping", e);
        }
    }

    @Override
    public boolean hasNeedInCache() {
        return false;
    }

    @Override
    public ODocument mapToODocument(T entity, ODocument doc, OPersistenceSession session) {
        this.checkMapping(session);
        if (doc == null) {
            doc = new ODocument(this.getSchemaClass());
        }
        for (Map.Entry<String, String> mapToDoc : this.mappingFromEntityToDoc.entrySet()) {
            Object value = PropertyResolver.getValue((String)mapToDoc.getKey(), entity);
            String docField = mapToDoc.getValue();
            int refIndex = docField.indexOf(46);
            if (refIndex < 0 && Objects.equal((Object)value, (Object)doc.field(docField))) continue;
            if (refIndex >= 0) {
                IEntityHandler refHandler;
                String refPkField = docField.substring(refIndex + 1);
                docField = docField.substring(0, refIndex);
                OProperty refProperty = doc.getSchemaClass().getProperty(docField);
                IEntityHandler iEntityHandler = refHandler = refProperty != null ? (IEntityHandler)HandlersManager.get().getHandlerBySchemaClass(refProperty.getLinkedClass()) : null;
                if (refHandler == null || !Objects.equal((Object)refPkField, (Object)refHandler.getPkField())) {
                    this.logger.error("Mapping for entity field '" + mapToDoc.getKey() + "' is wrongly set to '" + mapToDoc.getValue() + "'");
                    continue;
                }
                if (value != null) {
                    String referToId = value.toString();
                    OIdentifiable referTo = session.lookupOIdentifiableForIdInCache(referToId);
                    if (referTo == null) {
                        referTo = refHandler.readAsDocument(referToId, session);
                    }
                    if (Objects.equal((Object)doc.field(docField), (Object)referTo)) continue;
                    doc.field(docField, (Object)referTo);
                    continue;
                }
                doc.field(docField, null);
                continue;
            }
            doc.field(docField, this.convertValueFromEntity(mapToDoc.getKey(), value));
        }
        return doc;
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        helper.oClass(this.schemaClass, new String[]{"BPMEntity"});
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        helper.oClass(this.schemaClass, new String[]{"BPMEntity"});
    }

    @Override
    public boolean supportsStatement(String statement) {
        return this.statementMethodsMapping.containsKey(statement);
    }

    protected <T> T invokeStatement(String statement, Object ... args) {
        Method method = this.statementMethodsMapping.get(statement);
        try {
            return (T)method.invoke((Object)this, args);
        }
        catch (Exception e) {
            throw new IllegalStateException("With good defined handler we should not be here. Method: " + method, e);
        }
    }

    @Override
    public List<T> selectList(String statement, Object parameter, OPersistenceSession session) {
        return (List)this.invokeStatement(statement, new Object[]{session, parameter});
    }

    @Override
    public T selectOne(String statement, Object parameter, OPersistenceSession session) {
        return (T)((DbEntity)this.invokeStatement(statement, new Object[]{session, parameter}));
    }

    @Override
    public void lock(String statement, Object parameter, OPersistenceSession session) {
        this.invokeStatement(statement, new Object[]{session, parameter});
    }

    @Override
    public void deleteBulk(DbBulkOperation operation, OPersistenceSession session) {
        this.invokeStatement(operation.getStatement(), new Object[]{session, operation.getParameter()});
    }

    @Override
    public void updateBulk(DbBulkOperation operation, OPersistenceSession session) {
        this.invokeStatement(operation.getStatement(), new Object[]{session, operation.getParameter()});
    }

    protected T querySingle(OPersistenceSession session, String sql, Object ... args) {
        ODatabaseDocumentTx db = session.getDatabase();
        List ret = db.query((OQuery)new OSQLSynchQuery(sql, 1), args);
        return ret == null || ret.isEmpty() ? null : this.mapToEntity((ODocument)ret.get(0), null, session);
    }

    protected List<T> queryList(final OPersistenceSession session, String sql, Object ... args) {
        ODatabaseDocumentTx db = session.getDatabase();
        List ret = db.query((OQuery)new OSQLSynchQuery(sql), args);
        if (ret == null) {
            return Collections.emptyList();
        }
        return new ArrayList(Lists.transform((List)ret, (Function)new Function<ODocument, T>(){

            public T apply(ODocument input) {
                return AbstractEntityHandler.this.mapToEntity(input, null, session);
            }
        }));
    }

    protected void command(OPersistenceSession session, String sql, Object ... args) {
        ODatabaseDocumentTx db = session.getDatabase();
        db.command((OCommandRequest)new OCommandSQL(sql)).execute(args);
    }

    protected List<T> query(OPersistenceSession session, Query<?, ? super T> query, String ... ignoreFileds) {
        return this.query(session, query, (Function<com.github.raymanrt.orientqb.query.Query, com.github.raymanrt.orientqb.query.Query>)null, ignoreFileds);
    }

    protected List<T> query(OPersistenceSession session, Query<?, ? super T> query, Function<com.github.raymanrt.orientqb.query.Query, com.github.raymanrt.orientqb.query.Query> queryManger, String ... ignoreFileds) {
        try {
            OClass schemaClass = session.getClass(this.getSchemaClass());
            com.github.raymanrt.orientqb.query.Query q = new com.github.raymanrt.orientqb.query.Query().from(this.getSchemaClass());
            ArrayList<Object> args = new ArrayList<Object>();
            this.enrichWhereByBean(session, (AbstractQuery)q, schemaClass, query, args, Arrays.asList(ignoreFileds));
            if (queryManger != null) {
                q = (com.github.raymanrt.orientqb.query.Query)queryManger.apply((Object)q);
            }
            return this.queryList(session, q.toString(), args.toArray());
        }
        catch (Exception e) {
            throw new ProcessEngineException("Problems with read method of " + query.getClass().getName(), (Throwable)e);
        }
    }

    protected List<T> query(OPersistenceSession session, Map<String, ?> query, String ... ignoreFileds) {
        return this.query(session, query, (Function<com.github.raymanrt.orientqb.query.Query, com.github.raymanrt.orientqb.query.Query>)null, ignoreFileds);
    }

    protected List<T> query(OPersistenceSession session, Map<String, ?> query, Function<com.github.raymanrt.orientqb.query.Query, com.github.raymanrt.orientqb.query.Query> queryManger, String ... ignoreFileds) {
        OClass schemaClass = session.getClass(this.getSchemaClass());
        com.github.raymanrt.orientqb.query.Query q = new com.github.raymanrt.orientqb.query.Query().from(this.getSchemaClass());
        ArrayList<Object> args = new ArrayList<Object>();
        this.enrichWhereByMap(session, (AbstractQuery)q, schemaClass, query, args, Arrays.asList(ignoreFileds));
        if (queryManger != null) {
            q = (com.github.raymanrt.orientqb.query.Query)queryManger.apply((Object)q);
        }
        return this.queryList(session, q.toString(), args.toArray());
    }

    protected void delete(OPersistenceSession session, Query<?, ? super T> query, String ... ignoreFileds) {
        this.delete(session, query, (Function<com.github.raymanrt.orientqb.query.Query, com.github.raymanrt.orientqb.query.Query>)null, ignoreFileds);
    }

    protected void delete(OPersistenceSession session, Query<?, ? super T> query, Function<com.github.raymanrt.orientqb.query.Query, com.github.raymanrt.orientqb.query.Query> queryManger, String ... ignoreFileds) {
        try {
            OClass schemaClass = session.getClass(this.getSchemaClass());
            com.github.raymanrt.orientqb.query.Query q = new com.github.raymanrt.orientqb.query.Query().from(this.getSchemaClass());
            ArrayList<Object> args = new ArrayList<Object>();
            this.enrichWhereByBean(session, (AbstractQuery)q, schemaClass, query, args, Arrays.asList(ignoreFileds));
            if (queryManger != null) {
                q = (com.github.raymanrt.orientqb.query.Query)queryManger.apply((Object)q);
            }
            this.command(session, q.toString(), args.toArray());
        }
        catch (Exception e) {
            throw new ProcessEngineException("Problems with read method of " + query.getClass().getName(), (Throwable)e);
        }
    }

    protected void delete(OPersistenceSession session, Map<String, ?> query, String ... ignoreFileds) {
        this.delete(session, query, (Function<com.github.raymanrt.orientqb.query.Query, com.github.raymanrt.orientqb.query.Query>)null, ignoreFileds);
    }

    protected void delete(OPersistenceSession session, Map<String, ?> query, Function<com.github.raymanrt.orientqb.query.Query, com.github.raymanrt.orientqb.query.Query> queryManger, String ... ignoreFileds) {
        OClass schemaClass = session.getClass(this.getSchemaClass());
        com.github.raymanrt.orientqb.query.Query q = new com.github.raymanrt.orientqb.query.Query().from(this.getSchemaClass());
        ArrayList<Object> args = new ArrayList<Object>();
        this.enrichWhereByMap(session, (AbstractQuery)q, schemaClass, query, args, Arrays.asList(ignoreFileds));
        if (queryManger != null) {
            q = (com.github.raymanrt.orientqb.query.Query)queryManger.apply((Object)q);
        }
        this.command(session, q.toString(), args.toArray());
    }

    protected void enrichWhereByBean(OPersistenceSession session, AbstractQuery q, OClass schemaClass, Object query, List<Object> args, List<String> ignore) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.checkMapping(session);
        for (PropertyDescriptor pd : BeanUtils.getPropertyDescriptors(query.getClass())) {
            Object value;
            if (pd.getReadMethod() == null || !this.mappingFromEntityToDoc.containsKey(pd.getName()) && !this.mappingFromQueryToDoc.containsKey(pd.getName()) || ignore != null && ignore.contains(pd.getName())) continue;
            String docMapping = this.mappingFromEntityToDoc.get(pd.getName());
            if (docMapping == null) {
                docMapping = this.mappingFromQueryToDoc.get(pd.getName());
            }
            if ((value = pd.getReadMethod().invoke(query, new Object[0])) == null) continue;
            this.where(q, Clause.clause((String)docMapping, (Operator)Operator.EQ, (Object)Parameter.PARAMETER));
            args.add(this.convertValueFromEntity(pd.getName(), value));
        }
    }

    protected void enrichWhereByMap(OPersistenceSession session, AbstractQuery q, OClass schemaClass, Map<String, ?> query, List<Object> args, List<String> ignore) {
        this.checkMapping(session);
        for (Map.Entry<String, ?> entry : query.entrySet()) {
            Object value;
            if (!this.mappingFromEntityToDoc.containsKey(entry.getKey()) && !this.mappingFromEntityToDoc.containsKey(entry.getKey()) || ignore != null && ignore.contains(entry.getKey())) continue;
            String docMapping = this.mappingFromEntityToDoc.get(entry.getKey());
            if (docMapping == null) {
                docMapping = this.mappingFromQueryToDoc.get(entry.getKey());
            }
            if ((value = entry.getValue()) == null) continue;
            this.where(q, Clause.clause((String)docMapping, (Operator)Operator.EQ, (Object)Parameter.PARAMETER));
            args.add(this.convertValueFromEntity(entry.getKey(), value));
        }
    }

    protected AbstractQuery where(AbstractQuery q, Clause clause) {
        if (q instanceof com.github.raymanrt.orientqb.query.Query) {
            ((com.github.raymanrt.orientqb.query.Query)q).where(clause);
        } else if (q instanceof Delete) {
            ((Delete)q).where(clause);
        }
        return q;
    }

    @Override
    public ORecordHook.RESULT onTrigger(ODatabaseDocument db, ODocument doc, ORecordHook.TYPE iType) {
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }
}

