/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.AbstractEntityHandler;
import org.orienteer.bpm.camunda.handler.HandlersManager;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.OClassDomain;
import org.orienteer.core.util.OSchemaHelper;

public class EventSubscriptionEntityHandler
extends AbstractEntityHandler<EventSubscriptionEntity> {
    public static final String OCLASS_NAME = "BPMEventSubscription";

    public EventSubscriptionEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.domain(OClassDomain.SYSTEM);
        helper.oProperty("eventType", OType.STRING, 10).oProperty("eventName", OType.STRING, 20).oProperty("execution", OType.LINK, 30).assignVisualization("listbox").oProperty("processInstanceId", OType.STRING, 40).oProperty("activityId", OType.STRING, 50).oProperty("configuration", OType.STRING, 60).oProperty("created", OType.DATETIME, 70);
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship(OCLASS_NAME, "execution", "BPMExecution", "eventSubscriptions");
    }

    @Override
    public EventSubscriptionEntity mapToEntity(ODocument doc, EventSubscriptionEntity entity, OPersistenceSession session) {
        if (entity == null) {
            String eventType;
            switch (eventType = (String)doc.field("eventType")) {
                case "compensate": {
                    entity = new CompensateEventSubscriptionEntity();
                    break;
                }
                case "message": {
                    entity = new MessageEventSubscriptionEntity();
                    break;
                }
                case "signal": {
                    entity = new SignalEventSubscriptionEntity();
                }
            }
        }
        return super.mapToEntity(doc, entity, session);
    }

    @Statement
    public List<EventSubscriptionEntity> selectEventSubscriptionsByExecutionAndType(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.selectEventSubscriptionsByNameAndExecution(session, parameter);
    }

    @Statement
    public List<EventSubscriptionEntity> selectEventSubscriptionsByNameAndExecution(OPersistenceSession session, ListQueryParameterObject parameter) {
        Map map = (Map)parameter.getParameter();
        ArrayList<EventSubscriptionEntity> result = new ArrayList<EventSubscriptionEntity>();
        ExecutionEntity entity = HandlersManager.get().getHandler(ExecutionEntity.class).read((String)map.get("executionId"), session);
        if (entity == null) {
            return result;
        }
        for (EventSubscriptionEntity eventSubscriptionEntity : entity.getEventSubscriptions()) {
            if (map.containsKey("eventType") && !Objects.equals(eventSubscriptionEntity.getEventType(), map.get("eventType")) || map.containsKey("eventName") && !Objects.equals(eventSubscriptionEntity.getEventName(), map.get("eventName"))) continue;
            result.add(eventSubscriptionEntity);
        }
        return result;
    }

    @Statement
    public List<EventSubscriptionEntity> selectEventSubscriptionsByExecution(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where execution.id=?", parameter.getParameter());
    }

    @Statement
    public List<EventSubscriptionEntity> selectEventSubscriptionsByConfiguration(OPersistenceSession session, ListQueryParameterObject params) {
        Map map = (Map)params.getParameter();
        return this.queryList(session, "select from " + this.getSchemaClass() + " where configuration=? and eventType=?", map.get("configuration"), map.get("eventType"));
    }

    @Statement
    public List<EventSubscriptionEntity> selectMessageStartEventSubscriptionByName(OPersistenceSession session, ListQueryParameterObject params) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where eventType = ? and execution.id is null and eventName = ?", "message", params.getParameter());
    }
}

