/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.component;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.ResourceLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.string.Strings;
import org.orienteer.core.component.AbstractCommandsEnabledPanel;
import org.orienteer.core.component.BootstrapType;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.ICommandsSupportComponent;
import org.orienteer.core.component.command.Command;
import org.orienteer.core.component.command.EditODocumentCommand;
import org.orienteer.core.component.command.SaveODocumentCommand;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.event.ActionPerformedEvent;
import org.orienteer.wicketbpmnio.component.BpmnModeler;
import org.orienteer.wicketbpmnio.component.BpmnViewer;

public class BpmnPanel
extends AbstractCommandsEnabledPanel<ODocument> {
    private IModel<ODocument> pdModel;
    private IModel<DisplayMode> modeModel;
    private IModel<String> xmlModel = new LoadableDetachableModel<String>(){

        protected String load() {
            ODocument resource = (ODocument)BpmnPanel.this.getModelObject();
            byte[] xmlBytes = resource != null ? (byte[])resource.field("bytes") : null;
            return xmlBytes != null ? new String(xmlBytes) : null;
        }

        public void setObject(String object) {
            super.setObject((Object)object);
            ODocument resource = (ODocument)BpmnPanel.this.getModelObject();
            if (resource != null) {
                resource.field("bytes", (Object)object.getBytes());
            }
        }
    };
    private Component panel;

    public BpmnPanel(String id, IModel<ODocument> resourceModel, IModel<ODocument> pdModel, IModel<DisplayMode> modeModel) {
        super(id, resourceModel);
        this.setOutputMarkupId(true);
        this.pdModel = pdModel;
        this.modeModel = modeModel;
        this.addCommand((Command)new EditODocumentCommand(this.newCommandId(), resourceModel, modeModel));
        this.addCommand((Command)new SaveODocumentCommand((ICommandsSupportComponent)this, modeModel, resourceModel){

            public void onClick(AjaxRequestTarget target) {
                ODocument resource = (ODocument)this.getModelObject();
                if (resource.getIdentity().isNew()) {
                    ODocument pd = (ODocument)BpmnPanel.this.pdModel.getObject();
                    String resourceName = (String)pd.field("resourceName");
                    if (Strings.isEmpty((CharSequence)resourceName)) {
                        resourceName = pd.field("name") + ".bpmn";
                        pd.field("resourceName", (Object)resourceName);
                        pd.save();
                    }
                    resource.field("name", (Object)resourceName);
                    resource.field("deployment", pd.field("deployment"));
                }
                super.onClick(target);
            }
        });
        this.addCommand(new Command<ODocument>(this.newCommandId(), (IModel)new ResourceModel("command.download")){

            protected AbstractLink newLink(String id) {
                return new ResourceLink(id, (IResource)new AbstractResource(){

                    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
                        AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
                        resourceResponse.setContentType("text/xml");
                        resourceResponse.setFileName((String)((ODocument)BpmnPanel.this.getModelObject()).field("name"));
                        resourceResponse.setWriteCallback(new AbstractResource.WriteCallback(){

                            public void writeData(IResource.Attributes attributes) throws IOException {
                                OutputStream out = attributes.getResponse().getOutputStream();
                                out.write((byte[])((ODocument)BpmnPanel.this.getModelObject()).field("bytes"));
                            }
                        });
                        return resourceResponse;
                    }
                });
            }

            public void onClick() {
            }

            protected void onConfigure() {
                this.setVisible(!((DisplayMode)BpmnPanel.this.modeModel.getObject()).canModify());
                this.setEnabled(BpmnPanel.this.getModelObject() != null);
            }
        }.setBootstrapType(BootstrapType.PRIMARY).setIcon(FAIconType.download));
    }

    protected void onConfigure() {
        DisplayMode mode = (DisplayMode)this.modeModel.getObject();
        Component panel = this.get("panel");
        if (panel == null || panel instanceof BpmnViewer && !DisplayMode.VIEW.equals((Object)mode) || panel instanceof BpmnModeler && !DisplayMode.EDIT.equals((Object)mode)) {
            panel = DisplayMode.EDIT.equals((Object)mode) ? new BpmnModeler("panel", this.xmlModel) : new BpmnViewer("panel", this.xmlModel);
            this.form.addOrReplace(new Component[]{panel});
        }
        super.onConfigure();
    }

    public void onEvent(IEvent<?> event) {
        ActionPerformedEvent apEvent;
        if (event.getPayload() instanceof ActionPerformedEvent && event.getType().equals((Object)Broadcast.BUBBLE) && (apEvent = (ActionPerformedEvent)event.getPayload()).getCommand() != null && apEvent.getCommand().isChangingDisplayMode() && apEvent.isAjax()) {
            apEvent.getTarget().add(new Component[]{this});
        }
    }

    public void detachModels() {
        super.detachModels();
        this.modeModel.detach();
    }
}

