/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.component.command;

import com.orientechnologies.orient.core.record.impl.ODocument;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.camunda.bpm.BpmPlatform;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.TaskService;
import org.orienteer.bpm.component.widget.FormKey;
import org.orienteer.core.component.BootstrapType;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.command.SaveODocumentCommand;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.component.structuretable.OrienteerStructureTable;
import org.orienteer.core.util.CommonUtils;
import org.orienteer.core.web.ODocumentPage;

public class CompleteTaskCommand
extends SaveODocumentCommand {
    private final IModel<ODocument> taskModel;
    private final FormKey formKey;

    public CompleteTaskCommand(OrienteerStructureTable<ODocument, ?> component, IModel<ODocument> taskModel, IModel<DisplayMode> displayModeModel, FormKey formKey) {
        super(component, displayModeModel);
        this.taskModel = taskModel;
        this.formKey = formKey;
        this.setLabelModel((IModel)new ResourceModel("command.complete"));
        this.setAutoNotify(false);
        this.setForceCommit(true);
        this.setIcon(FAIconType.bolt);
        this.setBootstrapType(BootstrapType.SUCCESS);
        this.setChandingModel(true);
    }

    public void onClick(AjaxRequestTarget target) {
        super.onClick(target);
        ODocument doc = (ODocument)this.getModelObject();
        ProcessEngine processEngine = BpmPlatform.getDefaultProcessEngine();
        TaskService taskService = processEngine.getTaskService();
        String taskId = (String)((ODocument)this.taskModel.getObject()).field("id");
        String var = this.formKey.getVariableName();
        taskService.complete(taskId, CommonUtils.toMap((Object[])new Object[]{var, doc.getIdentity().toString()}));
        this.setResponsePage((IRequestablePage)new ODocumentPage(doc));
        this.sendActionPerformed();
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setVisible(((ODocument)this.getModelObject()).getIdentity().isPersistent() || this.getModeObject().canModify());
    }

    public void detachModels() {
        super.detachModels();
        this.taskModel.detach();
    }
}

