/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.component.widget;

import com.google.inject.Inject;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.ResourceModel;
import org.orienteer.bpm.component.widget.FormKey;
import org.orienteer.core.component.FAIcon;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.meta.ODocumentMetaPanel;
import org.orienteer.core.component.structuretable.OrienteerStructureTable;
import org.orienteer.core.service.IOClassIntrospector;
import org.orienteer.core.widget.AbstractModeAwareWidget;
import ru.ydn.wicket.wicketorientdb.model.ODocumentModel;

public abstract class AbstractFormWidget
extends AbstractModeAwareWidget<ODocument> {
    @Inject
    protected IOClassIntrospector oClassIntrospector;
    protected FormKey formKey = this.obtainFormKey();
    protected ODocumentModel formDocumentModel;
    protected OrienteerStructureTable<ODocument, OProperty> propertiesStructureTable;

    public AbstractFormWidget(String id, IModel<ODocument> model, IModel<ODocument> widgetDocumentModel) {
        super(id, model, widgetDocumentModel);
        String formKeyStr = this.formKey.toString();
        this.add(new Component[]{new Label("formKey", (Serializable)((Object)formKeyStr))});
        this.setVisible(this.formKey.isValid());
        this.formDocumentModel = new ODocumentModel((OIdentifiable)this.resolveODocument(this.formKey));
        Form form = new Form("form", this.getModel());
        LoadableDetachableModel<List<OProperty>> propertiesModel = new LoadableDetachableModel<List<OProperty>>(){

            protected List<OProperty> load() {
                return AbstractFormWidget.this.oClassIntrospector.listProperties(((ODocument)AbstractFormWidget.this.formDocumentModel.getObject()).getSchemaClass(), "parameters", Boolean.valueOf(false));
            }
        };
        this.propertiesStructureTable = new OrienteerStructureTable<ODocument, OProperty>("properties", (IModel)this.formDocumentModel, (IModel)propertiesModel){

            protected Component getValueComponent(String id, IModel<OProperty> rowModel) {
                return new ODocumentMetaPanel(id, AbstractFormWidget.this.getModeModel(), (IModel)AbstractFormWidget.this.formDocumentModel, rowModel);
            }
        };
        form.add(new Component[]{this.propertiesStructureTable});
        this.add(new Component[]{form});
    }

    protected abstract FormKey obtainFormKey();

    protected abstract ODocument resolveODocument(FormKey var1);

    protected FAIcon newIcon(String id) {
        return new FAIcon(id, FAIconType.tasks);
    }

    protected IModel<String> getDefaultTitleModel() {
        return new ResourceModel("widget.form");
    }

    public void detachModels() {
        super.detachModels();
        this.formDocumentModel.detach();
    }

    protected String getWidgetStyleClass() {
        return "strict";
    }
}

