/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.component.widget;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.util.io.IClusterable;
import org.camunda.bpm.engine.ProcessEngine;

public class FormKey
implements IClusterable {
    public static final String ORIENTEER_PREFIX = "orienteer:";
    private static final Pattern FORM_KEY_PATTERN = Pattern.compile("orienteer:((\\w+):)?(.*)", 2);
    private String schemaClassName;
    private String variableName;
    private ORID rid;

    private FormKey() {
    }

    public static FormKey parse(String formKey) {
        Matcher m;
        FormKey ret = new FormKey();
        if (formKey != null && (m = FORM_KEY_PATTERN.matcher(formKey)).matches()) {
            ret.schemaClassName = m.group(2);
            String val = m.group(3);
            if (ORecordId.isA((String)val)) {
                ret.rid = new ORecordId(val);
            } else {
                ret.variableName = val;
            }
        }
        return ret;
    }

    public String getSchemClassName() {
        return this.schemaClassName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public ORID getRid() {
        return this.rid;
    }

    public ODocument calculateODocument(ProcessEngine processEngine, String taskId) {
        Object recording;
        if (this.rid != null) {
            return (ODocument)this.rid.getRecord();
        }
        if (this.variableName != null && (recording = processEngine.getTaskService().getVariable(taskId, this.variableName)) != null) {
            return (ODocument)new ORecordId(recording.toString()).getRecord();
        }
        if (this.schemaClassName != null) {
            return new ODocument(this.schemaClassName);
        }
        return null;
    }

    public boolean isValid() {
        return this.variableName != null || this.rid != null;
    }

    public String toString() {
        return ORIENTEER_PREFIX + (this.schemaClassName != null ? this.schemaClassName + ":" : "") + (this.variableName != null ? this.variableName : (this.rid != null ? this.rid.toString() : ""));
    }
}

