/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationUnavailableException;
import org.orienteer.bpm.camunda.BpmnHook;
import org.orienteer.bpm.camunda.OProcessApplication;
import org.orienteer.bpm.camunda.handler.HandlersManager;
import org.orienteer.core.CustomAttribute;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.module.AbstractOrienteerModule;
import org.orienteer.core.util.OSchemaHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPMModule
extends AbstractOrienteerModule {
    private static final Logger LOG = LoggerFactory.getLogger(BPMModule.class);
    private ProcessApplicationReference processApplicationReference;

    protected BPMModule() {
        super("bpm", 2, new String[]{"devutils"});
    }

    public ODocument onInstall(OrienteerWebApplication app, ODatabaseDocument db) {
        super.onInstall(app, db);
        OSchemaHelper helper = OSchemaHelper.bind((ODatabaseDocument)db);
        helper.oAbstractClass("BPMEntity", new String[0]).oProperty("id", OType.STRING, 0).updateCustomAttribute(CustomAttribute.UI_READONLY, (Object)true).oIndex(OClass.INDEX_TYPE.UNIQUE);
        HandlersManager.get().applySchema(helper);
        return null;
    }

    public void onUpdate(OrienteerWebApplication app, ODatabaseDocument db, int oldVersion, int newVersion) {
        super.onUpdate(app, db, oldVersion, newVersion);
        this.onInstall(app, db);
    }

    public void onInitialize(OrienteerWebApplication app, ODatabaseDocument db) {
        super.onInitialize(app, db);
        app.mountPages("org.orienteer.bpm.web");
        OProcessApplication processApplication = new OProcessApplication();
        processApplication.deploy();
        this.processApplicationReference = processApplication.getReference();
        app.registerWidgets("org.orienteer.bpm.component.widget");
        app.getOrientDbSettings().getORecordHooks().add(BpmnHook.class);
    }

    public void onDestroy(OrienteerWebApplication app, ODatabaseDocument db) {
        super.onDestroy(app, db);
        app.unregisterWidgets("org.orienteer.bpm.component.widget");
        app.unmountPages("org.orienteer.bpm.web");
        app.getOrientDbSettings().getORecordHooks().remove(BpmnHook.class);
        if (this.processApplicationReference != null) {
            try {
                this.processApplicationReference.getProcessApplication().undeploy();
            }
            catch (ProcessApplicationUnavailableException e) {
                LOG.error("Can't undeploy process application", (Throwable)e);
            }
        }
    }
}

