/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.AbstractEntityHandler;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.OClassDomain;
import org.orienteer.core.util.OSchemaHelper;

public class ExternalTaskEntityHandler
extends AbstractEntityHandler<ExternalTaskEntity> {
    public static final String OCLASS_NAME = "BPMExternalTask";

    public ExternalTaskEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.domain(OClassDomain.SYSTEM);
        helper.oProperty("topicName", OType.STRING, 10).markAsDocumentName().markDisplayable().oProperty("workerId", OType.STRING, 20).markDisplayable().oProperty("retries", OType.INTEGER, 30).markDisplayable().oProperty("errorMessage", OType.STRING, 40).oProperty("lockExpirationTime", OType.DATETIME, 50).oProperty("suspensionState", OType.INTEGER, 60).oProperty("execution", OType.LINK, 70).assignVisualization("listbox").oProperty("processInstanceId", OType.STRING, 80).markDisplayable().oProperty("processDefinition", OType.LINK, 90).assignVisualization("listbox").markDisplayable().oProperty("processDefinitionKey", OType.STRING, 100).oProperty("activityId", OType.STRING, 110).oProperty("activityInstanceId", OType.STRING, 120).oProperty("priority", OType.LONG, 140).markDisplayable();
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship(OCLASS_NAME, "processDefinition", "BPMProcessDefinition");
        helper.setupRelationship(OCLASS_NAME, "execution", "BPMExecution");
    }

    @Statement
    public List<ExternalTaskEntity> selectExternalTaskByQueryCriteria(OPersistenceSession session, ExternalTaskQuery query) {
        return this.query(session, query, new String[0]);
    }

    @Statement
    public List<ExternalTaskEntity> selectExternalTasksByExecutionId(OPersistenceSession session, ListQueryParameterObject query) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where execution.id = ?", query.getParameter());
    }

    @Statement
    public List<ExternalTaskEntity> selectExternalTasksForTopics(OPersistenceSession session, ListQueryParameterObject query) {
        Map map = (Map)query.getParameter();
        String sql = "select from " + this.getSchemaClass() + " where (lockExpirationTime is null or lockExpirationTime <= ?) and (suspensionState is null or suspensionState = 1) and topicName in ? limit ?";
        return this.queryList(session, sql, map.get("now"), map.get("topics"), query.getMaxResults());
    }
}

