/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.orienteer.bpm.camunda.handler.AttachmentEntityHandler;
import org.orienteer.bpm.camunda.handler.AuthorizationEntityHandler;
import org.orienteer.bpm.camunda.handler.BatchEntityHandler;
import org.orienteer.bpm.camunda.handler.ByteArrayEntityHandler;
import org.orienteer.bpm.camunda.handler.CaseDefinitionEntityHandler;
import org.orienteer.bpm.camunda.handler.CaseExecutionEntityHandler;
import org.orienteer.bpm.camunda.handler.CaseSentryPartEntityHandler;
import org.orienteer.bpm.camunda.handler.CommentEntityHandler;
import org.orienteer.bpm.camunda.handler.DecisionDefinitionEntityHandler;
import org.orienteer.bpm.camunda.handler.DeploymentEntityHandler;
import org.orienteer.bpm.camunda.handler.EventSubscriptionEntityHandler;
import org.orienteer.bpm.camunda.handler.ExecutionEntityHandler;
import org.orienteer.bpm.camunda.handler.ExternalTaskEntityHandler;
import org.orienteer.bpm.camunda.handler.FilterEntityHandler;
import org.orienteer.bpm.camunda.handler.GroupEntityHandler;
import org.orienteer.bpm.camunda.handler.IEntityHandler;
import org.orienteer.bpm.camunda.handler.IdentityInfoEntityHandler;
import org.orienteer.bpm.camunda.handler.IdentityLinkEntityHandler;
import org.orienteer.bpm.camunda.handler.IncidentEntityHandler;
import org.orienteer.bpm.camunda.handler.JobDefinitionEntityHandler;
import org.orienteer.bpm.camunda.handler.JobEntityHandler;
import org.orienteer.bpm.camunda.handler.MembershipEntityHandler;
import org.orienteer.bpm.camunda.handler.MeterLogEntityHandler;
import org.orienteer.bpm.camunda.handler.ProcessDefinitionEntityHandler;
import org.orienteer.bpm.camunda.handler.PropertyEntityHandler;
import org.orienteer.bpm.camunda.handler.ResourceEntityHandler;
import org.orienteer.bpm.camunda.handler.TaskEntityHandler;
import org.orienteer.bpm.camunda.handler.TenantEntityHandler;
import org.orienteer.bpm.camunda.handler.TenantMembershipEntityHandler;
import org.orienteer.bpm.camunda.handler.UserEntityHandler;
import org.orienteer.bpm.camunda.handler.VariableInstanceEntityHandler;
import org.orienteer.bpm.camunda.handler.history.HistoricActivityInstanceEventEntityHandler;
import org.orienteer.bpm.camunda.handler.history.HistoricBatchEntityHandler;
import org.orienteer.bpm.camunda.handler.history.HistoricCaseActivityInstanceEventEntityHandler;
import org.orienteer.bpm.camunda.handler.history.HistoricCaseInstanceEventEntityHandler;
import org.orienteer.bpm.camunda.handler.history.HistoricDecisionInputInstanceEntityHandler;
import org.orienteer.bpm.camunda.handler.history.HistoricDecisionInstanceEntityHandler;
import org.orienteer.bpm.camunda.handler.history.HistoricDecisionOutputInstanceEntityHandler;
import org.orienteer.bpm.camunda.handler.history.HistoricDetailEventEntityHandler;
import org.orienteer.bpm.camunda.handler.history.HistoricIdentityLinkLogEventEntityHandler;
import org.orienteer.bpm.camunda.handler.history.HistoricIncidentEventEntityHandler;
import org.orienteer.bpm.camunda.handler.history.HistoricJobLogEventEntityHandler;
import org.orienteer.bpm.camunda.handler.history.HistoricProcessInstanceEventEntityHandler;
import org.orienteer.bpm.camunda.handler.history.HistoricTaskInstanceEventEntityHandler;
import org.orienteer.bpm.camunda.handler.history.HistoricVariableInstanceEntityHandler;
import org.orienteer.bpm.camunda.handler.history.UserOperationLogEntryEventEntityHandler;
import org.orienteer.core.util.OSchemaHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HandlersManager {
    private static final Logger LOG = LoggerFactory.getLogger(HandlersManager.class);
    private static final HandlersManager INSTANCE = new HandlersManager();
    private Map<Class<?>, IEntityHandler<?>> handlers = new HashMap();
    private Map<Class<?>, IEntityHandler<?>> cachedInheritedHandlers = new HashMap();
    private Map<Class<?>, IEntityHandler<?>> handlerByHandlerClass = new HashMap();
    private Map<String, IEntityHandler<?>> handlerBySchemaClass = new HashMap();
    private Map<String, IEntityHandler<?>> statementHandlersCache = new HashMap();

    private HandlersManager() {
        this.register(new PropertyEntityHandler(), new DeploymentEntityHandler(), new ResourceEntityHandler(), new ProcessDefinitionEntityHandler(), new JobDefinitionEntityHandler(), new ExecutionEntityHandler(), new EventSubscriptionEntityHandler(), new VariableInstanceEntityHandler(), new JobEntityHandler(), new ByteArrayEntityHandler(), new TaskEntityHandler(), new IncidentEntityHandler(), new CaseDefinitionEntityHandler(), new CaseSentryPartEntityHandler(), new CaseExecutionEntityHandler(), new ExternalTaskEntityHandler(), new TenantEntityHandler(), new MeterLogEntityHandler(), new UserEntityHandler(), new GroupEntityHandler(), new IdentityLinkEntityHandler(), new HistoricVariableInstanceEntityHandler(), new HistoricProcessInstanceEventEntityHandler(), new HistoricActivityInstanceEventEntityHandler(), new HistoricTaskInstanceEventEntityHandler(), new HistoricBatchEntityHandler(), new HistoricCaseActivityInstanceEventEntityHandler(), new HistoricCaseInstanceEventEntityHandler(), new HistoricDecisionInputInstanceEntityHandler(), new HistoricDecisionInstanceEntityHandler(), new HistoricDecisionOutputInstanceEntityHandler(), new HistoricDetailEventEntityHandler(), new HistoricIdentityLinkLogEventEntityHandler(), new HistoricIncidentEventEntityHandler(), new HistoricJobLogEventEntityHandler(), new AttachmentEntityHandler(), new AuthorizationEntityHandler(), new BatchEntityHandler(), new CommentEntityHandler(), new DecisionDefinitionEntityHandler(), new FilterEntityHandler(), new IdentityInfoEntityHandler(), new MembershipEntityHandler(), new TenantMembershipEntityHandler(), new UserOperationLogEntryEventEntityHandler());
    }

    public static HandlersManager get() {
        return INSTANCE;
    }

    private void register(IEntityHandler<?> ... handlers) {
        for (IEntityHandler<?> handler : handlers) {
            this.handlers.put(handler.getEntityClass(), handler);
            this.handlerByHandlerClass.put(handler.getClass(), handler);
            this.handlerBySchemaClass.put(handler.getSchemaClass(), handler);
        }
        this.cachedInheritedHandlers.clear();
    }

    public <T extends IEntityHandler<?>> T getHandlerBySchemaClass(String schemaClass) {
        return (T)this.handlerBySchemaClass.get(schemaClass);
    }

    public <T extends IEntityHandler<?>> T getHandlerBySchemaClass(OClass schemaClass) {
        return schemaClass != null ? (T)this.getHandlerBySchemaClass(schemaClass.getName()) : null;
    }

    public <T extends IEntityHandler<?>> T getHandlerByClass(Class<T> handlerClass) {
        return (T)this.handlerByHandlerClass.get(handlerClass);
    }

    public <T extends DbEntity> IEntityHandler<T> getHandler(Class<? extends T> type) {
        IEntityHandler<? extends T> ret = this.getHandlerSafe(type);
        if (ret == null) {
            throw new IllegalStateException("Handler for class '" + type.getName() + "' was not found");
        }
        return ret;
    }

    public <T extends DbEntity> IEntityHandler<T> getHandlerSafe(Class<? extends T> type) {
        IEntityHandler<?> ret = this.handlers.get(type);
        if (ret == null) {
            if (this.cachedInheritedHandlers.containsKey(type)) {
                ret = this.cachedInheritedHandlers.get(type);
            } else {
                for (Map.Entry<Class<?>, IEntityHandler<?>> h : this.handlers.entrySet()) {
                    if (!h.getKey().isAssignableFrom(type)) continue;
                    ret = h.getValue();
                    break;
                }
                this.cachedInheritedHandlers.put(type, ret);
            }
        }
        return ret;
    }

    public <T extends DbEntity> IEntityHandler<T> getHandler(String statement) {
        IEntityHandler<T> ret = this.getHandlerSafe(statement);
        if (ret == null) {
            throw new IllegalStateException("Handler for statement '" + statement + "' was not found");
        }
        return ret;
    }

    public <T extends DbEntity> IEntityHandler<T> getHandlerSafe(String statement) {
        IEntityHandler<?> ret = null;
        if (this.statementHandlersCache.containsKey(statement)) {
            ret = this.statementHandlersCache.get(statement);
        } else {
            for (IEntityHandler<?> handler : this.handlers.values()) {
                if (!handler.supportsStatement(statement)) continue;
                ret = handler;
            }
            this.statementHandlersCache.put(statement, ret);
        }
        return ret;
    }

    public Collection<IEntityHandler<?>> getAllHandlers() {
        return this.handlers.values();
    }

    public void applySchema(OSchemaHelper helper) {
        Collection<IEntityHandler<?>> allHandlers = this.getAllHandlers();
        for (IEntityHandler<?> handler : allHandlers) {
            handler.applySchema(helper);
        }
        for (IEntityHandler<?> handler : allHandlers) {
            handler.applyRelationships(helper);
        }
    }

    public ORecordHook.RESULT onTrigger(ODatabaseDocument db, ODocument doc, ORecordHook.TYPE iType) {
        Object handler = this.getHandlerBySchemaClass(doc.getSchemaClass());
        if (handler != null) {
            return handler.onTrigger(db, doc, iType);
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }
}

