/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityInfoEntity;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.AbstractEntityHandler;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.OClassDomain;
import org.orienteer.core.util.OSchemaHelper;

public class IdentityInfoEntityHandler
extends AbstractEntityHandler<IdentityInfoEntity> {
    public static final String OCLASS_NAME = "BPMIdentityInfo";

    public IdentityInfoEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.domain(OClassDomain.SYSTEM);
        helper.oProperty("userId", OType.STRING, 10).oProperty("type", OType.STRING, 20).oProperty("key", OType.STRING, 30).oProperty("value", OType.STRING, 40).oProperty("passwordBytes", OType.BYTE, 50).oProperty("parentId", OType.STRING, 60);
    }

    @Statement
    public List<IdentityInfoEntity> selectIdentityInfoByUserIdAndKey(OPersistenceSession session, ListQueryParameterObject parameter) {
        Map params = (Map)parameter.getParameter();
        return this.queryList(session, "select from " + this.getSchemaClass() + " where userId = ? and key = ? and parentId is null", params.get("userId"), params.get("key"));
    }

    @Statement
    public String selectIdentityInfoKeysByUserIdAndType(OPersistenceSession session, ListQueryParameterObject parameter) {
        Map params = (Map)parameter.getParameter();
        return ((IdentityInfoEntity)this.querySingle(session, "select key from " + this.getSchemaClass() + " where userId = ? and type = ? and parentId is null", params.get("userId"), params.get("type"))).getKey();
    }

    @Statement
    public List<IdentityInfoEntity> selectIdentityInfoByUserId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where userId = ?", parameter.getParameter());
    }

    @Statement
    public List<IdentityInfoEntity> selectIdentityInfoDetails(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where parentId = ?", parameter.getParameter());
    }
}

