/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkEntity;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.AbstractEntityHandler;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.OClassDomain;
import org.orienteer.core.util.OSchemaHelper;

public class IdentityLinkEntityHandler
extends AbstractEntityHandler<IdentityLinkEntity> {
    public static final String OCLASS_NAME = "BPMIdentityLink";

    public IdentityLinkEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.domain(OClassDomain.SYSTEM);
        helper.oProperty("type", OType.STRING, 10).markDisplayable().oProperty("user", OType.LINK, 20).markDisplayable().oProperty("group", OType.LINK, 20).markDisplayable().oProperty("task", OType.LINK, 40).markAsDocumentName().markAsLinkToParent().oProperty("processDefinition", OType.LINK, 50).markDisplayable();
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship(OCLASS_NAME, "user", "OUser", "availableTasks");
        helper.setupRelationship(OCLASS_NAME, "group", "ORole", "availableGroupTasks");
        helper.setupRelationship(OCLASS_NAME, "task", "BPMTask", "candidatesIdentityLinks");
        helper.setupRelationship(OCLASS_NAME, "processDefinition", "BPMProcessDefinition");
    }

    @Override
    protected void initMapping(OPersistenceSession session) {
        super.initMapping(session);
        this.mappingFromDocToEntity.put("processDefinition.id", "processDefId");
        this.mappingFromEntityToDoc.put("processDefId", "processDefinition.id");
    }

    @Statement
    public List<IdentityLinkEntity> selectIdentityLinksByTask(OPersistenceSession session, ListQueryParameterObject param) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where task.id=?", param.getParameter());
    }

    @Statement
    public List<IdentityLinkEntity> selectIdentityLinksByProcessDefinition(OPersistenceSession session, ListQueryParameterObject param) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where processDefinition.id=?", param.getParameter());
    }

    @Statement
    public void deleteIdentityLinkByProcDef(OPersistenceSession session, String procDefId) {
        this.command(session, "delete from " + this.getSchemaClass() + " where processDefinition.id=?", procDefId);
    }

    @Statement
    public List<IdentityLinkEntity> selectIdentityLinkByTaskUserGroupAndType(OPersistenceSession session, ListQueryParameterObject param) {
        Map map = (Map)param.getParameter();
        return this.query(session, map, new String[0]);
    }

    @Statement
    public List<IdentityLinkEntity> selectIdentityLinkByProcessDefinitionUserAndGroup(OPersistenceSession session, ListQueryParameterObject param) {
        Map map = (Map)param.getParameter();
        return this.query(session, map, new String[0]);
    }
}

