/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.AbstractEntityHandler;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.util.OSchemaHelper;

public class IncidentEntityHandler
extends AbstractEntityHandler<IncidentEntity> {
    public static final String OCLASS_NAME = "BPMIncident";

    public IncidentEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.oProperty("incidentTimestamp", OType.DATETIME, 20).oProperty("incidentMessage", OType.STRING, 30).oProperty("incidentType", OType.STRING, 40).oProperty("execution", OType.LINK, 50).assignVisualization("listbox").oProperty("activityId", OType.STRING, 60).oProperty("processInstanceId", OType.STRING, 70).oProperty("processDefinition", OType.LINK, 80).assignVisualization("listbox").oProperty("causeIncidentId", OType.STRING, 90).oProperty("rootCauseIncidentId", OType.STRING, 100).oProperty("configuration", OType.STRING, 110).oProperty("jobDefinitionId", OType.STRING, 130);
    }

    @Override
    public void create(IncidentEntity entity, OPersistenceSession session) {
        super.create(entity, session);
        this.logger.warn("Incident happened: " + entity);
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship(OCLASS_NAME, "processDefinition", "BPMProcessDefinition");
        helper.setupRelationship(OCLASS_NAME, "execution", "BPMExecution");
    }

    @Statement
    public List<IncidentEntity> selectIncidentsByExecutionId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where execution.id=?", parameter.getParameter());
    }

    @Statement
    public List<IncidentEntity> selectIncidentsByProcessInstanceId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where processInstanceId=?", parameter.getParameter());
    }

    @Statement
    public List<IncidentEntity> selectIncidentsByConfiguration(OPersistenceSession session, ListQueryParameterObject parameter) {
        Map map = (Map)parameter.getParameter();
        String query = "select from " + this.getSchemaClass() + " where configuration=?";
        if (map.containsKey("incidentType") && map.get("incidentType") != null) {
            query = query + " and incidentType=?";
            return this.queryList(session, query, map.get("configuration"), map.get("incidentType"));
        }
        return this.queryList(session, query, map.get("configuration"));
    }

    @Statement
    public List<IncidentEntity> selectIncidentsByQueryCriteria(OPersistenceSession session, IncidentQuery query) {
        return this.query(session, query, new String[0]);
    }
}

