/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.List;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.AbstractEntityHandler;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.OClassDomain;
import org.orienteer.core.util.OSchemaHelper;

public class JobDefinitionEntityHandler
extends AbstractEntityHandler<JobDefinitionEntity> {
    public static final String OCLASS_NAME = "BPMJobDefinition";

    public JobDefinitionEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.domain(OClassDomain.SYSTEM);
        helper.oProperty("processDefinition", OType.LINK, 10).assignVisualization("listbox").oProperty("processDefinitionKey", OType.STRING, 20).oProperty("activityId", OType.STRING, 30).oProperty("jobType", OType.STRING, 40).oProperty("jobConfiguration", OType.STRING, 50).oProperty("jobPriority", OType.LONG, 60).oProperty("suspensionState", OType.INTEGER, 70).oProperty("historyIncidentEvents", OType.LINKLIST, 80).assignVisualization("table").oProperty("historyJobLogEvents", OType.LINKLIST, 90).assignVisualization("table").oProperty("userOperationLogEntryEvents", OType.LINKLIST, 100).assignVisualization("table");
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship(OCLASS_NAME, "processDefinition", "BPMProcessDefinition");
        helper.setupRelationship(OCLASS_NAME, "historyIncidentEvents", "BPMHistoricIncidentEvent", "jobDefinition");
        helper.setupRelationship(OCLASS_NAME, "historyJobLogEvents", "BPMHistoricJobLogEvent", "jobDefinition");
        helper.setupRelationship(OCLASS_NAME, "userOperationLogEntryEvents", "BPMUserOperationLogEntryEvent", "jobDefinition");
    }

    @Override
    protected void initMapping(OPersistenceSession session) {
        super.initMapping(session);
        this.mappingFromEntityToDoc.remove("jobPriority");
        this.mappingFromEntityToDoc.put("overridingJobPriority", "jobPriority");
    }

    @Statement
    public List<JobDefinitionEntity> selectJobDefinitionsByProcessDefinitionId(OPersistenceSession session, ListQueryParameterObject query) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where processDefinition.id = ?", query.getParameter());
    }

    @Statement
    public List<JobDefinitionEntity> selectJobDefinitionByQueryCriteria(OPersistenceSession session, JobDefinitionQuery query) {
        return this.query(session, query, new String[0]);
    }

    @Statement
    public void deleteJobDefinitionsByProcessDefinitionId(OPersistenceSession session, String processDefinitionId) {
        this.command(session, "delete from " + this.getSchemaClass() + " where processDefinition.id = ?", processDefinitionId);
    }
}

