/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.orienteer.bpm.camunda.BpmnHook;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.OProcessEngineConfiguration;
import org.orienteer.bpm.camunda.handler.AbstractEntityHandler;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.util.OSchemaHelper;

public class ProcessDefinitionEntityHandler
extends AbstractEntityHandler<ProcessDefinitionEntity> {
    public static final String OCLASS_NAME = "BPMProcessDefinition";

    public ProcessDefinitionEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.oProperty("name", OType.STRING, 10).markDisplayable().markAsDocumentName().notNull(true).oProperty("key", OType.STRING, 30).notNull(true).markDisplayable().oProperty("resourceName", OType.STRING, 35).oProperty("category", OType.STRING, 40).markDisplayable().oProperty("deployment", OType.LINK, 60).assignVisualization("listbox").markDisplayable().markAsLinkToParent().oProperty("executions", OType.LINKLIST, 70).assignVisualization("table").oProperty("suspensionState", OType.INTEGER, 80).defaultValue("1").notNull().oProperty("tasks", OType.LINKLIST, 90).assignVisualization("table").oProperty("historyEvents", OType.LINKLIST, 100).assignTab("history").assignVisualization("table").oProperty("historyVariableInstances", OType.LINKLIST, 110).assignTab("history").assignVisualization("table");
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship(OCLASS_NAME, "deployment", "BPMDeployment", "processDefinitions");
        helper.setupRelationship(OCLASS_NAME, "executions", "BPMExecution", "processDefinition");
        helper.setupRelationship(OCLASS_NAME, "tasks", "BPMTask", "processDefinition");
        helper.setupRelationship(OCLASS_NAME, "historyEvents", "BPMHistoryEvent", "processDefinition");
        helper.setupRelationship(OCLASS_NAME, "historyVariableInstances", "BPMHistoricVariableInstance", "processDefinition");
    }

    @Override
    public ORecordHook.RESULT onTrigger(ODatabaseDocument db, ODocument doc, ORecordHook.TYPE iType) {
        if (iType.equals((Object)ORecordHook.TYPE.BEFORE_CREATE)) {
            ODocument deployment = (ODocument)doc.field("deployment");
            if (deployment == null) {
                List deployments = db.query((OQuery)new OSQLSynchQuery("select from BPMDeployment", 1), new Object[0]);
                ODocument oDocument = deployment = deployments != null && !deployments.isEmpty() ? (ODocument)deployments.get(0) : null;
                if (deployment == null) {
                    deployment = new ODocument("BPMDeployment");
                    deployment.field("id", (Object)BpmnHook.getNextId());
                    deployment.field("name", (Object)"Orienteer");
                    deployment.save();
                }
                doc.field("deployment", (Object)deployment);
                return ORecordHook.RESULT.RECORD_CHANGED;
            }
        } else if (iType.equals((Object)ORecordHook.TYPE.AFTER_UPDATE) || iType.equals((Object)ORecordHook.TYPE.AFTER_DELETE)) {
            DeploymentCache dc = OProcessEngineConfiguration.get().getDeploymentCache();
            dc.removeProcessDefinition((String)doc.field("id"));
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Statement
    public List<ProcessDefinitionEntity> selectLatestProcessDefinitionByKey(OPersistenceSession session, ListQueryParameterObject param) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where key = ? order by @rid desc limit 1", param.getParameter());
    }

    @Statement
    public ProcessDefinitionEntity selectLatestProcessDefinitionByKeyWithoutTenantId(OPersistenceSession session, Map<String, Object> params) {
        return (ProcessDefinitionEntity)this.querySingle(session, "select from " + this.getSchemaClass() + " where key = ? order by @rid desc", params.get("processDefinitionKey"));
    }

    @Statement
    public List<ProcessDefinitionEntity> selectProcessDefinitionByDeploymentId(OPersistenceSession session, ListQueryParameterObject param) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where deployment.id = ?", param.getParameter());
    }

    @Statement
    public List<ProcessDefinitionEntity> selectProcessDefinitionByKeyIn(OPersistenceSession session, ListQueryParameterObject params) {
        String[] keys = (String[])params.getParameter();
        return this.queryList(session, "select from " + this.getSchemaClass() + " where key in ?", new Object[]{keys});
    }

    @Statement
    public List<ProcessDefinitionEntity> selectProcessDefinitionsByQueryCriteria(OPersistenceSession session, ProcessDefinitionQuery query) {
        return this.query(session, query, new String[0]);
    }

    @Statement
    public ProcessDefinitionEntity selectProcessDefinitionByDeploymentAndKey(OPersistenceSession session, Map<String, Object> map) {
        return (ProcessDefinitionEntity)this.querySingle(session, "select from " + this.getSchemaClass() + " where deployment.id = ? and key = ?", map.get("deploymentId"), map.get("processDefinitionKey"));
    }

    @Statement
    public void deleteProcessDefinitionsByDeploymentId(OPersistenceSession session, String deploymentId) {
        session.getDatabase().command((OCommandRequest)new OCommandSQL("delete from " + this.getSchemaClass() + " where deployment.id = ?")).execute(new Object[]{deploymentId});
    }
}

