/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.task.TaskQuery;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.AbstractEntityHandler;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.util.OSchemaHelper;

public class TaskEntityHandler
extends AbstractEntityHandler<TaskEntity> {
    public static final String OCLASS_NAME = "BPMTask";

    public TaskEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.oProperty("name", OType.STRING, 20).markAsDocumentName().markDisplayable().oProperty("parentTask", OType.LINK, 30).assignVisualization("listbox").oProperty("childTasks", OType.LINKLIST, 31).assignVisualization("table").oProperty("description", OType.STRING, 40).markDisplayable().oProperty("priority", OType.INTEGER, 50).markDisplayable().oProperty("createTime", OType.DATETIME, 60).markDisplayable().oProperty("owner", OType.LINK, 70).markDisplayable().oProperty("assignee", OType.LINK, 80).markDisplayable().oProperty("delegationStateString", OType.STRING, 90).oProperty("execution", OType.LINK, 100).assignVisualization("listbox").oProperty("processInstance", OType.LINK, 110).markAsLinkToParent().markDisplayable().oProperty("processDefinition", OType.LINK, 120).oProperty("caseExecutionId", OType.STRING, 130).oProperty("caseInstanceId", OType.STRING, 140).oProperty("caseDefinitionId", OType.STRING, 150).oProperty("taskDefinitionKey", OType.STRING, 160).oProperty("dueDate", OType.DATETIME, 170).markDisplayable().oProperty("followUpDate", OType.DATETIME, 180).markDisplayable().oProperty("suspensionState", OType.INTEGER, 190).oProperty("variables", OType.LINKLIST, 200).assignVisualization("table").oProperty("candidatesIdentityLinks", OType.LINKLIST, 200).assignVisualization("table").defaultTab("form").oProperty("historyActivityInstances", OType.LINKLIST, 210).assignVisualization("table").oProperty("historyCaseActivityEventInstances", OType.LINKLIST, 220).assignVisualization("table").oProperty("historyDetailEvents", OType.LINKLIST, 230).assignVisualization("table").oProperty("historicProcessInstances", OType.LINKLIST, 240).assignVisualization("table").oProperty("historyVariableInstances", OType.LINKLIST, 250).assignVisualization("table").oProperty("userOperationLogEntryEvents", OType.LINKLIST, 260).assignVisualization("table");
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship(OCLASS_NAME, "assignee", "OUser", "assignedTasks");
        helper.setupRelationship(OCLASS_NAME, "owner", "OUser", "ownedTasks");
        helper.setupRelationship(OCLASS_NAME, "processDefinition", "BPMProcessDefinition", "tasks");
        helper.setupRelationship(OCLASS_NAME, "parentTask", OCLASS_NAME, "childTasks");
        helper.setupRelationship(OCLASS_NAME, "childTasks", OCLASS_NAME, "parentTask");
        helper.setupRelationship(OCLASS_NAME, "processInstance", "BPMExecution", "tasks");
        helper.setupRelationship(OCLASS_NAME, "variables", "BPMVariable", "task");
        helper.setupRelationship(OCLASS_NAME, "execution", "BPMExecution");
        helper.setupRelationship(OCLASS_NAME, "candidatesIdentityLinks", "BPMIdentityLink", "task");
        helper.setupRelationship(OCLASS_NAME, "historyActivityInstances", "BPMHistoricActivityInstanceEvent", "task");
        helper.setupRelationship(OCLASS_NAME, "historyCaseActivityEventInstances", "BPMHistoricCaseActivityInstanceEvent", "task");
        helper.setupRelationship(OCLASS_NAME, "historyDetailEvents", "BPMHistoricDetailEvent", "task");
        helper.setupRelationship(OCLASS_NAME, "historicProcessInstances", "BPMHistoricProcessInstanceEvent", "task");
        helper.setupRelationship(OCLASS_NAME, "historyVariableInstances", "BPMHistoricVariableInstance", "task");
        helper.setupRelationship(OCLASS_NAME, "userOperationLogEntryEvents", "BPMUserOperationLogEntryEvent", "task");
    }

    @Override
    protected void initMapping(OPersistenceSession session) {
        super.initMapping(session);
        this.mappingFromDocToEntity.keySet().removeAll(Arrays.asList("name", "parentTask.id", "description", "priority", "owner", "assignee", "caseInstanceId", "taskDefinitionKey", "dueDate", "followUpDate"));
        this.mappingFromEntityToDoc.put("assignee", "assignee.name");
        this.mappingFromQueryToDoc.put("taskId", "id");
    }

    @Override
    public TaskEntity mapToEntity(ODocument doc, TaskEntity entity, OPersistenceSession session) {
        TaskEntity ret = super.mapToEntity(doc, entity, session);
        ret.setNameWithoutCascade((String)doc.field("name"));
        ret.setParentTaskIdWithoutCascade((String)doc.field("parentTask.id"));
        ret.setDescriptionWithoutCascade((String)doc.field("description"));
        ret.setPriorityWithoutCascade(((Integer)doc.field("priority")).intValue());
        ret.setOwnerWithoutCascade((String)doc.field("owner"));
        ret.setAssigneeWithoutCascade((String)doc.field("assignee.name"));
        ret.setCaseInstanceIdWithoutCascade((String)doc.field("caseInstanceId"));
        ret.setTaskDefinitionKeyWithoutCascade((String)doc.field("taskDefinitionKey"));
        ret.setDueDateWithoutCascade((Date)doc.field("dueDate"));
        ret.setFollowUpDateWithoutCascade((Date)doc.field("followUpDate"));
        return ret;
    }

    @Statement
    public List<TaskEntity> selectTasksByParentTaskId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where parentTask.id=?", parameter.getParameter());
    }

    @Statement
    public List<TaskEntity> selectTasksByExecutionId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where execution.id=?", parameter.getParameter());
    }

    @Statement
    public List<TaskEntity> selectTasksByProcessInstanceId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where proccessInstanceId=?", parameter.getParameter());
    }

    @Statement
    public List<TaskEntity> selectTaskByCaseExecutionId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where caseExecutionId=?", parameter.getParameter());
    }

    @Statement
    public List<TaskEntity> selectTaskByQueryCriteria(OPersistenceSession session, TaskQuery query) {
        return this.query(session, query, new String[0]);
    }
}

