/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler.history;

import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.HashMap;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.bpm.camunda.handler.history.HistoricEventHandler;
import org.orienteer.core.OClassDomain;
import org.orienteer.core.util.OSchemaHelper;

public class HistoricJobLogEventEntityHandler
extends HistoricEventHandler<HistoricJobLogEventEntity> {
    public static final String OCLASS_NAME = "BPMHistoricJobLogEvent";

    public HistoricJobLogEventEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.oClass(OCLASS_NAME, new String[]{"BPMHistoryEvent"}).domain(OClassDomain.SYSTEM).oProperty("timestamp", OType.DATETIME, 10).oProperty("jobId", OType.STRING, 20).oProperty("jobDueDate", OType.DATETIME, 30).oProperty("jobRetries", OType.INTEGER, 40).oProperty("jobPriority", OType.LONG, 50).oProperty("jobExceptionMessage", OType.STRING, 60).oProperty("exceptionByteArrayId", OType.STRING, 70).oProperty("state", OType.INTEGER, 80).oProperty("jobDefinition", OType.LINK, 90).oProperty("jobDefinitionType", OType.STRING, 100).oProperty("jobDefinitionConfiguration", OType.STRING, 110).oProperty("activityId", OType.STRING, 120).oProperty("deployment", OType.LINK, 170);
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship(OCLASS_NAME, "jobDefinition", "BPMJobDefinition", "historyJobLogEvents");
        helper.setupRelationship(OCLASS_NAME, "deployment", "BPMDeployment");
    }

    @Statement
    public void deleteHistoricJobLogByDeploymentId(OPersistenceSession session, String deploymentId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        this.delete(session, params, new String[0]);
    }

    @Statement
    public void deleteHistoricJobLogByProcessDefinitionId(OPersistenceSession session, String processDefinitionId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processDefinitionId", processDefinitionId);
        this.delete(session, params, new String[0]);
    }

    @Statement
    public void deleteHistoricJobLogByProcessInstanceId(OPersistenceSession session, String processInstanceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstanceId", processInstanceId);
        this.delete(session, params, new String[0]);
    }
}

