/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler.history;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.NonUniqIdConverter;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.bpm.camunda.handler.history.HistoricScopeInstanceEventHandler;
import org.orienteer.core.util.OSchemaHelper;
import ru.ydn.wicket.wicketorientdb.utils.GetODocumentFieldValueFunction;

public class HistoricProcessInstanceEventEntityHandler
extends HistoricScopeInstanceEventHandler<HistoricProcessInstanceEventEntity> {
    public static final String OCLASS_NAME = "BPMHistoricProcessInstanceEvent";
    private static final Function<ODocument, String> GET_ID_FUNCTION = new GetODocumentFieldValueFunction("id");

    public HistoricProcessInstanceEventEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.oClass(OCLASS_NAME, new String[]{"BPMHistoricScopeInstanceEventHandler"}).oProperty("parentActivityInstanceId", OType.STRING, 10).oProperty("activityId", OType.STRING, 60).oProperty("task", OType.LINK, 70).oProperty("calledProcessInstanceId", OType.STRING, 80).oProperty("calledCaseInstanceId", OType.STRING, 90).oProperty("activityName", OType.STRING, 100).oProperty("activityType", OType.STRING, 110).oProperty("taskAssignee", OType.STRING, 120).oProperty("activityInstanceState", OType.INTEGER, 160);
    }

    @Override
    protected void initMapping(OPersistenceSession session) {
        super.initMapping(session);
        this.mappingConvertors.put("id", new NonUniqIdConverter("pi:"));
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship(OCLASS_NAME, "task", "BPMTask", "historicProcessInstances");
    }

    @Statement
    public List<String> selectHistoricProcessInstanceIdsByProcessDefinitionId(OPersistenceSession session, ListQueryParameterObject parameter) {
        ODatabaseDocumentTx db = session.getDatabase();
        List resultSet = db.query((OQuery)new OSQLSynchQuery("select id from " + this.getSchemaClass() + " where processDefinition.id = ?"), new Object[]{parameter.getParameter()});
        return Lists.transform((List)resultSet, GET_ID_FUNCTION);
    }

    @Statement
    public void deleteHistoricProcessInstance(OPersistenceSession session, String processInstanceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstanceId", processInstanceId);
        this.delete(session, params, new String[0]);
    }
}

