/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler.history;

import com.github.raymanrt.orientqb.query.Query;
import com.github.raymanrt.orientqb.query.core.AbstractQuery;
import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.history.event.HistoricTaskInstanceEventEntity;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.NonUniqIdConverter;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.bpm.camunda.handler.history.HistoricScopeInstanceEventHandler;
import org.orienteer.core.util.OSchemaHelper;
import ru.ydn.wicket.wicketorientdb.utils.GetODocumentFieldValueFunction;

public class HistoricTaskInstanceEventEntityHandler
extends HistoricScopeInstanceEventHandler<HistoricTaskInstanceEventEntity> {
    public static final String OCLASS_NAME = "BPMHistoricTaskInstanceEvent";
    private static final NonUniqIdConverter ID_CONVERTER = new NonUniqIdConverter("ti:");
    private static final Converter<Object, Object> ID_CONVERTER_REVERSE = ID_CONVERTER.reverse();
    private static final Function<ODocument, String> GET_ID_FUNCTION = new GetODocumentFieldValueFunction<String>("id"){

        public String apply(ODocument input) {
            String id = (String)super.apply(input);
            return id == null ? null : ID_CONVERTER_REVERSE.convert((Object)id).toString();
        }
    };

    public HistoricTaskInstanceEventEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.oClass(OCLASS_NAME, new String[]{"BPMHistoricScopeInstanceEventHandler"}).oProperty("name", OType.STRING, 10).markAsDocumentName().oProperty("processExecutionId", OType.STRING, 40).oProperty("activityInstanceId", OType.STRING, 90).oProperty("parentTaskId", OType.STRING, 110).oProperty("description", OType.STRING, 120).oProperty("owner", OType.STRING, 130).oProperty("assignee", OType.STRING, 140).oProperty("deleteReason", OType.STRING, 180).oProperty("taskDefinitionKey", OType.STRING, 190).oProperty("priority", OType.INTEGER, 200).oProperty("dueDate", OType.DATETIME, 210).oProperty("followUpDate", OType.DATETIME, 220);
    }

    @Override
    protected void initMapping(OPersistenceSession session) {
        super.initMapping(session);
        this.mappingConvertors.put("id", new NonUniqIdConverter("ti:"));
    }

    @Statement
    public List<String> selectHistoricTaskInstanceIdsByParameters(OPersistenceSession session, ListQueryParameterObject parameters) {
        Map params = (Map)parameters.getParameter();
        Query q = new Query().from(this.getSchemaClass());
        ArrayList<Object> args = new ArrayList<Object>();
        this.enrichWhereByMap(session, (AbstractQuery)q, session.getClass(this.getSchemaClass()), params, args, null);
        List docs = session.getDatabase().query((OQuery)new OSQLSynchQuery(q.toString()), new Object[]{args});
        return docs == null ? new ArrayList() : Lists.transform((List)docs, GET_ID_FUNCTION);
    }
}

