/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import org.camunda.bpm.BpmPlatform;
import org.orienteer.bpm.camunda.OProcessEngineConfiguration;
import org.orienteer.bpm.camunda.handler.HandlersManager;

public class BpmnHook
implements ORecordHook {
    protected ODatabaseDocument database;

    public BpmnHook() {
        this.database = ODatabaseRecordThreadLocal.instance().get();
    }

    public BpmnHook(ODatabaseDocument database) {
        this.database = database;
    }

    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.BOTH;
    }

    public ORecordHook.RESULT onTrigger(ORecordHook.TYPE iType, ORecord iRecord) {
        if (this.database.getStatus() != ODatabase.STATUS.OPEN) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        if (!(iRecord instanceof ODocument)) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        ODocument doc = (ODocument)iRecord;
        OClass oClass = doc.getSchemaClass();
        ORecordHook.RESULT res = ORecordHook.RESULT.RECORD_NOT_CHANGED;
        if (oClass != null && oClass.isSubClassOf("BPMEntity")) {
            ORecordHook.RESULT handlerRes;
            if (iType.equals((Object)ORecordHook.TYPE.BEFORE_CREATE) && doc.field("id") == null) {
                doc.field("id", (Object)BpmnHook.getNextId());
                res = ORecordHook.RESULT.RECORD_CHANGED;
            }
            res = (handlerRes = HandlersManager.get().onTrigger(this.database, doc, iType)) == ORecordHook.RESULT.RECORD_NOT_CHANGED || handlerRes == null ? res : handlerRes;
        }
        return res;
    }

    public static String getNextId() {
        return ((OProcessEngineConfiguration)BpmPlatform.getDefaultProcessEngine().getProcessEngineConfiguration()).getIdGenerator().getNextId();
    }

    public void onUnregister() {
    }
}

