/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.AbstractEntityHandler;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.util.OSchemaHelper;

public class CaseDefinitionEntityHandler
extends AbstractEntityHandler<CaseDefinitionEntity> {
    public static final String OCLASS_NAME = "BPMCaseDefinition";

    public CaseDefinitionEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.oProperty("category", OType.STRING, 10).oProperty("name", OType.STRING, 0).oProperty("key", OType.STRING, 20).oProperty("version", OType.INTEGER, 30).oProperty("deployment", OType.LINK, 40).oProperty("resourceName", OType.STRING, 50).oProperty("diagramResourceName", OType.STRING, 60).oProperty("historyEvents", OType.LINKLIST, 70).assignTab("history").assignVisualization("table").oProperty("historyVariableInstances", OType.LINKLIST, 80).assignVisualization("table");
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship(OCLASS_NAME, "deployment", "BPMDeployment");
        helper.setupRelationship(OCLASS_NAME, "historyEvents", "BPMHistoryEvent", "caseDefinition");
        helper.setupRelationship(OCLASS_NAME, "historyVariableInstances", "BPMHistoricVariableInstance", "caseDefinition");
    }

    @Statement
    public List<CaseDefinitionEntity> selectCaseDefinitionByDeploymentId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where deployment.id=?", parameter.getParameter());
    }

    @Statement
    public List<CaseDefinitionEntity> selectCaseDefinitionByDeploymentAndKey(OPersistenceSession session, ListQueryParameterObject parameter) {
        Map map = (Map)parameter.getParameter();
        return this.queryList(session, "select from " + this.getSchemaClass() + " where deployment.id=? and key=?", map.get("deploymentId"), map.get("key"));
    }

    @Statement
    public List<CaseDefinitionEntity> selectLatestCaseDefinitionByKey(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " c1 inner join (select key, tenantId, max(version) as max_version from " + this.getSchemaClass() + " res where key=? group by tenantId, key) c2 on c1.key = c2.key where c1.version = c2.max_version and (c1.tenantId = c2.tenantId or (c1.tenantId is null and c2.tenantId is null))", parameter.getParameter());
    }

    @Statement
    public List<CaseDefinitionEntity> selectLatestCaseDefinitionByKeyWithoutTenantId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where key = ? and tenantId is null and version(select max(version) from" + this.getSchemaClass() + " where key = ? and tenantId is null)", parameter.getParameter(), parameter.getParameter());
    }

    @Statement
    public List<CaseDefinitionEntity> selectLatestCaseDefinitionByKeyAndTenantId(OPersistenceSession session, ListQueryParameterObject parameter) {
        Map map = (Map)parameter.getParameter();
        String key = ((String)map.get("caseDefinitionKey")).toString();
        String tenantId = ((String)map.get("tenantId")).toString();
        String query = "select from " + this.getSchemaClass() + " where key = ?  and tenantId = ? and version = (select max(version) from " + this.getSchemaClass() + " where key = ? and tenantId = ?)";
        return this.queryList(session, query, key, tenantId, key, tenantId);
    }

    @Statement
    public List<CaseDefinitionEntity> selectCaseDefinitionByKeyVersionAndTenantId(OPersistenceSession session, ListQueryParameterObject parameter) {
        Map map = (Map)parameter.getParameter();
        String key = map.get("caseDefinitionKey").toString();
        Integer version = Integer.getInteger(map.get("caseDefinitionVersion").toString());
        String tenantId = map.get("tenantId").toString();
        String query = "select from " + this.getSchemaClass() + " where key=" + key + " and version=" + version;
        query = tenantId == null ? query + " and tenantId is null" : query + " and tenantid=" + tenantId;
        return this.queryList(session, query, new Object[0]);
    }

    public CaseDefinitionEntity selectPreviousCaseDefinitionId(OPersistenceSession session, ListQueryParameterObject parameter) {
        Map map = (Map)parameter.getParameter();
        String key = map.get("key").toString();
        Integer version = Integer.getInteger(map.get("version").toString());
        String tenantId = map.get("tenantId").toString();
        String query = "select distinct res.* from " + this.getSchemaClass() + " res where res.key = " + key;
        query = query + (tenantId != null ? " and tenantId=" + tenantId : " and tenantId is null");
        query = query + " and res.version = (select max(version) from " + this.getSchemaClass() + " where key=" + key;
        query = query + (tenantId != null ? " and tenantId=" + tenantId : " and tenantId is null");
        query = query + " and version < " + version + ")";
        return (CaseDefinitionEntity)this.querySingle(session, query, new Object[0]);
    }

    @Statement
    public List<CaseDefinitionEntity> selectCaseDefinitionByQueryCriteria(OPersistenceSession session, CaseDefinitionQuery query) {
        return this.query(session, query, new String[0]);
    }

    @Statement
    public void deleteCaseDefinitionsByDeploymentId(OPersistenceSession session, String deploymentId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        this.delete(session, params, new String[0]);
    }
}

