/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.List;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.AbstractEntityHandler;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.util.OSchemaHelper;

public class CaseExecutionEntityHandler
extends AbstractEntityHandler<CaseExecutionEntity> {
    public static final String OCLASS_NAME = "BPMCaseExecution";

    public CaseExecutionEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.oProperty("caseInstanceId", OType.STRING, 10).oProperty("businessKey", OType.STRING, 20).oProperty("caseDefinitionId", OType.STRING, 30).oProperty("activityId", OType.STRING, 40).oProperty("parentId", OType.STRING, 50).oProperty("superCaseExecutionId", OType.STRING, 60).oProperty("superExecutionId", OType.STRING, 70).oProperty("state", OType.INTEGER, 80).oProperty("previous", OType.INTEGER, 90).oProperty("required", OType.BOOLEAN, 100).oProperty("historyEvents", OType.LINKLIST, 110).assignTab("history").assignVisualization("table").oProperty("historyVariableInstances", OType.LINKLIST, 120).assignVisualization("table");
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship(OCLASS_NAME, "historyEvents", "BPMHistoryEvent", "caseExecution");
        helper.setupRelationship(OCLASS_NAME, "historyVariableInstances", "BPMHistoricVariableInstance", "caseExecution");
    }

    @Statement
    public List<CaseExecutionEntity> selectCaseExecutionsByParentCaseExecutionId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where parentId = ?", parameter.getParameter());
    }

    @Statement
    public List<CaseExecutionEntity> selectCaseExecutionsByCaseInstanceId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where caseInstanceId = ?", parameter.getParameter());
    }

    @Statement
    public String selectCaseInstanceIdsByCaseDefinitionId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return ((CaseExecutionEntity)this.querySingle(session, "select id from " + this.getSchemaClass() + " where caseDefinitionId = ? and parentId is null", parameter.getParameter())).toString();
    }

    @Statement
    public List<CaseExecutionEntity> selectSubCaseInstanceBySuperCaseExecutionId(OPersistenceSession session, String parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where superCaseExecutionId = ?", parameter);
    }

    @Statement
    public List<CaseExecutionEntity> selectSubCaseInstanceBySuperExecutionId(OPersistenceSession session, String parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where superExecutionId = ?", parameter);
    }

    @Statement
    public List<CaseExecutionEntity> selectCaseExecutionsByQueryCriteria(OPersistenceSession session, CaseExecutionQuery query) {
        return this.query(session, query, new String[0]);
    }

    @Statement
    public List<CaseExecutionEntity> selectCaseInstanceByQueryCriteria(OPersistenceSession session, CaseExecutionQuery query) {
        return this.query(session, query, new String[0]);
    }
}

