/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.List;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.AbstractEntityHandler;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.util.OSchemaHelper;

public class DeploymentEntityHandler
extends AbstractEntityHandler<DeploymentEntity> {
    public static final String OCLASS_NAME = "BPMDeployment";

    public DeploymentEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.oProperty("name", OType.STRING, 0).markAsDocumentName().markDisplayable().oProperty("deploymentTime", OType.DATETIME, 30).defaultValue("sysdate()").markDisplayable().oProperty("processDefinitions", OType.LINKLIST, 40).assignVisualization("table").assignTab("resources").oProperty("resources", OType.LINKLIST, 50).assignVisualization("table").assignTab("resources");
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship("BPMProcessDefinition", "deployment", OCLASS_NAME, "processDefinitions");
        helper.setupRelationship("BPMResource", "deployment", OCLASS_NAME, "resources");
    }

    @Statement
    public DeploymentEntity selectDeploymentByDeploymentName(OPersistenceSession session, String deploymentName) {
        return (DeploymentEntity)this.querySingle(session, "select from " + this.getSchemaClass() + " where name = ?", deploymentName);
    }

    @Statement
    public List<DeploymentEntity> selectDeploymentsByName(OPersistenceSession session, ListQueryParameterObject params) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where name = ?", params.getParameter());
    }

    @Statement
    public void deleteDeployment(OPersistenceSession session, String deploymentId) {
        session.getDatabase().command((OCommandRequest)new OCommandSQL("delete from " + this.getSchemaClass() + " where id = ?")).execute(new Object[]{deploymentId});
    }
}

