/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.github.raymanrt.orientqb.query.Clause;
import com.github.raymanrt.orientqb.query.Operator;
import com.github.raymanrt.orientqb.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.regex.Pattern;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryValue;
import org.camunda.bpm.engine.impl.ExecutionQueryImpl;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.QueryVariableValue;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.AbstractEntityHandler;
import org.orienteer.bpm.camunda.handler.IQueryMangler;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.util.OSchemaHelper;
import ru.ydn.wicket.wicketorientdb.utils.GetODocumentFieldValueFunction;

public class ExecutionEntityHandler
extends AbstractEntityHandler<ExecutionEntity> {
    public static final String OCLASS_NAME = "BPMExecution";
    private static final Function<ODocument, String> GET_ID_FUNCTION = new GetODocumentFieldValueFunction("id");

    public ExecutionEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.oProperty("processInstanceId", OType.STRING, 10).oProperty("parentId", OType.STRING, 20).oProperty("processDefinition", OType.LINK, 30).assignVisualization("listbox").markAsLinkToParent().markDisplayable().markAsDocumentName().oProperty("created", OType.DATETIME, 30).defaultValue("sysdate()").markDisplayable().oProperty("businessKey", OType.STRING, 30).markDisplayable().oProperty("superExecution", OType.LINK, 40).assignVisualization("listbox").oProperty("superCaseExecutionId", OType.STRING, 50).oProperty("caseInstanceId", OType.STRING, 60).oProperty("activityInstanceId", OType.STRING, 70).oProperty("activityId", OType.STRING, 80).oProperty("active", OType.BOOLEAN, 90).oProperty("concurrent", OType.BOOLEAN, 100).oProperty("scope", OType.BOOLEAN, 120).oProperty("eventScope", OType.BOOLEAN, 120).oProperty("suspensionState", OType.INTEGER, 140).oProperty("cachedEntityState", OType.INTEGER, 150).oProperty("sequenceCounter", OType.LONG, 160).oProperty("childExecutions", OType.LINKLIST, 170).assignVisualization("table").oProperty("tasks", OType.LINKLIST, 180).assignVisualization("table").oProperty("eventSubscriptions", OType.LINKLIST, 190).assignVisualization("table").oProperty("variables", OType.LINKLIST, 200).assignVisualization("table").oProperty("historyEvents", OType.LINKLIST, 210).assignTab("history").assignVisualization("table").oProperty("historyVariableInstances", OType.LINKLIST, 220).assignVisualization("table");
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship(OCLASS_NAME, "processDefinition", "BPMProcessDefinition", "executions");
        helper.setupRelationship(OCLASS_NAME, "superExecution", OCLASS_NAME, "childExecutions");
        helper.setupRelationship(OCLASS_NAME, "childExecutions", OCLASS_NAME, "superExecution");
        helper.setupRelationship(OCLASS_NAME, "tasks", "BPMTask", "execution");
        helper.setupRelationship(OCLASS_NAME, "eventSubscriptions", "BPMEventSubscription", "execution");
        helper.setupRelationship(OCLASS_NAME, "variables", "BPMVariable", "execution");
    }

    @Statement
    public List<ExecutionEntity> selectProcessInstanceByQueryCriteria(OPersistenceSession session, ProcessInstanceQueryImpl query) {
        return this.query(session, query, (Function<Query, Query>)new IQueryMangler(){

            public Query apply(Query input) {
                input.where(Clause.clause((String)"parentId", (Operator)Operator.NULL, (Object)""));
                return input;
            }
        }, new String[0]);
    }

    @Statement
    public List<ExecutionEntity> selectExecutionsByQueryCriteria(final OPersistenceSession session, final ExecutionQueryImpl query) {
        List queryVariableValues;
        List<ExecutionEntity> ret = this.query(session, query, new Function<Query, Query>(){

            public Query apply(Query input) {
                List proc;
                String businessKey;
                SuspensionState state = query.getSuspensionState();
                if (state != null) {
                    input.where(Clause.clause((String)"suspensionState", (Operator)Operator.EQ, (Object)state.getStateCode()));
                }
                if ((businessKey = query.getBusinessKey()) != null && (proc = session.getDatabase().query((OQuery)new OSQLSynchQuery("select processInstanceId from " + ExecutionEntityHandler.this.getSchemaClass() + " where businessKey=?", 1), new Object[]{businessKey})) != null && !proc.isEmpty()) {
                    String processInstanceId = (String)((ODocument)proc.get(0)).field("processInstanceId");
                    input.where(Clause.clause((String)"processInstanceId", (Operator)Operator.EQ, (Object)processInstanceId));
                }
                return input;
            }
        }, new String[]{"suspensionState", "businessKey"});
        List subscriptionsQueries = query.getEventSubscriptions();
        if (subscriptionsQueries != null && !subscriptionsQueries.isEmpty()) {
            ret = new ArrayList(ret);
            for (EventSubscriptionQueryValue sub : subscriptionsQueries) {
                ListIterator<ExecutionEntity> it = ret.listIterator();
                while (it.hasNext()) {
                    ExecutionEntity entity = it.next();
                    List subscriptions = entity.getEventSubscriptions();
                    boolean hasMatch = false;
                    for (EventSubscriptionEntity subscription : subscriptions) {
                        if (sub.getEventName() != null && !sub.getEventName().equals(subscription.getEventName()) || sub.getEventType() != null && !sub.getEventType().equals(subscription.getEventType())) continue;
                        hasMatch = true;
                    }
                    if (hasMatch) continue;
                    it.remove();
                }
            }
        }
        if ((queryVariableValues = query.getQueryVariableValues()) != null && !queryVariableValues.isEmpty()) {
            ret = new ArrayList<ExecutionEntity>(ret);
            for (QueryVariableValue queryValue : queryVariableValues) {
                ListIterator<ExecutionEntity> it = ret.listIterator();
                while (it.hasNext()) {
                    boolean hasMatch;
                    ExecutionEntity entity = it.next();
                    QueryOperator operator = queryValue.getOperator();
                    Object value = entity.getVariable(queryValue.getName());
                    Object refValue = queryValue.getValue();
                    Comparable comparable = value instanceof Comparable && refValue instanceof Comparable ? (Comparable)value : null;
                    switch (operator) {
                        case GREATER_THAN: {
                            boolean bl = comparable != null && comparable.compareTo(refValue) > 0;
                        }
                        case GREATER_THAN_OR_EQUAL: {
                            boolean bl = comparable != null && comparable.compareTo(refValue) >= 0;
                        }
                        case LESS_THAN: {
                            boolean bl = comparable != null && comparable.compareTo(refValue) < 0;
                        }
                        case LESS_THAN_OR_EQUAL: {
                            boolean bl = comparable != null && comparable.compareTo(refValue) <= 0;
                        }
                        case LIKE: {
                            hasMatch = value != null && Pattern.matches(refValue.toString(), value.toString());
                            break;
                        }
                        case NOT_EQUALS: {
                            hasMatch = !Objects.equals(value, refValue);
                            break;
                        }
                        default: {
                            hasMatch = Objects.equals(value, refValue);
                        }
                    }
                    if (hasMatch) continue;
                    it.remove();
                }
            }
        }
        return ret;
    }

    @Override
    public boolean hasNeedInCache() {
        return true;
    }

    @Statement
    public List<ExecutionEntity> selectExecutionsByProcessInstanceId(OPersistenceSession session, ListQueryParameterObject obj) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where processInstanceId = ?", obj.getParameter());
    }

    @Statement
    public List<ExecutionEntity> selectExecutionsByParentExecutionId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where parentId = ?", parameter.getParameter());
    }

    @Statement
    public List<String> selectProcessInstanceIdsByProcessDefinitionId(OPersistenceSession session, ListQueryParameterObject parameter) {
        ODatabaseDocumentTx db = session.getDatabase();
        List resultSet = db.query((OQuery)new OSQLSynchQuery("select id from " + this.getSchemaClass() + " where processDefinition.id = ?"), new Object[]{parameter.getParameter()});
        return Lists.transform((List)resultSet, GET_ID_FUNCTION);
    }
}

