/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.OProcessEngineConfiguration;
import org.orienteer.bpm.camunda.handler.AbstractEntityHandler;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.util.OSchemaHelper;

public class ResourceEntityHandler
extends AbstractEntityHandler<ResourceEntity> {
    public static final String OCLASS_NAME = "BPMResource";

    public ResourceEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.oProperty("name", OType.STRING, 0).markAsDocumentName().markDisplayable().oProperty("deployment", OType.LINK, 10).assignVisualization("listbox").markDisplayable().oProperty("bytes", OType.BINARY, 20).oProperty("generated", OType.BOOLEAN, 40).defaultValue("true").notNull();
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship(OCLASS_NAME, "deployment", "BPMDeployment", "resources");
    }

    @Override
    public ORecordHook.RESULT onTrigger(ODatabaseDocument db, ODocument doc, ORecordHook.TYPE iType) {
        String name;
        List pds;
        if ((iType.equals((Object)ORecordHook.TYPE.AFTER_CREATE) || iType.equals((Object)ORecordHook.TYPE.AFTER_UPDATE) || iType.equals((Object)ORecordHook.TYPE.AFTER_DELETE)) && (pds = db.query((OQuery)new OSQLSynchQuery("select from BPMProcessDefinition where resourceName = ?"), new Object[]{name = (String)doc.field("name")})) != null) {
            DeploymentCache dc = OProcessEngineConfiguration.get().getDeploymentCache();
            for (ODocument pd : pds) {
                dc.removeProcessDefinition((String)pd.field("id"));
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Statement
    public ResourceEntity selectResourceByDeploymentIdAndResourceName(OPersistenceSession session, Map<String, Object> map) {
        return (ResourceEntity)this.querySingle(session, "select from " + this.getSchemaClass() + " where deployment.id=? and name=?", map.get("deploymentId"), map.get("resourceName"));
    }

    @Statement
    public List<ResourceEntity> selectResourcesByDeploymentId(OPersistenceSession session, ListQueryParameterObject param) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where deployment.id=?", param.getParameter());
    }

    @Statement
    public List<ResourceEntity> selectLatestResourcesByDeploymentName(OPersistenceSession session, ListQueryParameterObject params) {
        Map map = (Map)params.getParameter();
        return this.queryList(session, "select from " + this.getSchemaClass() + " where deployment.name=? and name in ?", map.get("deploymentName"), map.get("resourcesToFind"));
    }

    @Statement
    public void deleteResourcesByDeploymentId(OPersistenceSession session, String deploymentId) {
        session.getDatabase().command((OCommandRequest)new OCommandSQL("delete from " + this.getSchemaClass() + " where deployment.id = ?")).execute(new Object[]{deploymentId});
    }
}

