/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.camunda.handler;

import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.orienteer.bpm.camunda.OPersistenceSession;
import org.orienteer.bpm.camunda.handler.AbstractEntityHandler;
import org.orienteer.bpm.camunda.handler.Statement;
import org.orienteer.core.util.OSchemaHelper;

public class VariableInstanceEntityHandler
extends AbstractEntityHandler<VariableInstanceEntity> {
    public static final String OCLASS_NAME = "BPMVariable";

    public VariableInstanceEntityHandler() {
        super(OCLASS_NAME);
    }

    @Override
    public void applySchema(OSchemaHelper helper) {
        super.applySchema(helper);
        helper.oProperty("serializerName", OType.STRING, 30).oProperty("name", OType.STRING, 20).oProperty("execution", OType.LINK, 40).assignVisualization("listbox").oProperty("processInstanceId", OType.STRING, 50).oProperty("caseExecutionId", OType.STRING, 60).oProperty("caseInstanceId", OType.STRING, 70).oProperty("task", OType.LINK, 80).assignVisualization("listbox").oProperty("byteArrayValue", OType.LINK, 90).oProperty("doubleValue", OType.DOUBLE, 100).oProperty("longValue", OType.LONG, 110).oProperty("textValue", OType.STRING, 120).oProperty("textValue2", OType.STRING, 130).oProperty("sequenceCounter", OType.LONG, 140).oProperty("concurrentLocal", OType.BOOLEAN, 150);
    }

    @Override
    public void applyRelationships(OSchemaHelper helper) {
        super.applyRelationships(helper);
        helper.setupRelationship(OCLASS_NAME, "execution", "BPMExecution", "variables");
        helper.setupRelationship(OCLASS_NAME, "task", "BPMTask", "variables");
        helper.setupRelationship(OCLASS_NAME, "byteArrayValue", "BPMByteArray");
    }

    @Statement
    public List<VariableInstanceEntity> selectVariablesByExecutionId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where execution.id=?", parameter.getParameter());
    }

    @Statement
    public List<VariableInstanceEntity> selectVariablesByTaskId(OPersistenceSession session, ListQueryParameterObject parameter) {
        return this.queryList(session, "select from " + this.getSchemaClass() + " where task.id=?", parameter.getParameter());
    }

    @Statement
    public void deleteByteArrayNoRevisionCheck(OPersistenceSession session, String id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        this.delete(session, params, new String[0]);
    }
}

