/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.bpm.component.widget;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Optional;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.camunda.bpm.BpmPlatform;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.Task;
import org.orienteer.bpm.component.command.CompleteTaskCommand;
import org.orienteer.bpm.component.widget.AbstractFormWidget;
import org.orienteer.bpm.component.widget.FormKey;
import org.orienteer.core.component.command.Command;
import org.orienteer.core.component.command.EditODocumentCommand;
import org.orienteer.core.component.command.SaveODocumentCommand;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.widget.Widget;
import ru.ydn.wicket.wicketorientdb.model.NvlModel;

@Widget(id="user-task-form", domain="document", selector="BPMTask", autoEnable=true, tab="form")
public class TaskFormWidget
extends AbstractFormWidget {
    private SaveODocumentCommand saveODocumentCommand;

    public TaskFormWidget(String id, IModel<ODocument> model, IModel<ODocument> widgetDocumentModel) {
        super(id, model, widgetDocumentModel);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.propertiesStructureTable.addCommand((Command)new EditODocumentCommand(this.propertiesStructureTable, this.getModeModel()));
        this.saveODocumentCommand = new SaveODocumentCommand(this.propertiesStructureTable, this.getModeModel()){

            public void onClick(Optional<AjaxRequestTarget> targetOptional) {
                super.onClick(targetOptional);
                TaskFormWidget.this.associateTaskWithDocument();
            }
        }.setForceCommit(true);
        this.propertiesStructureTable.addCommand((Command)this.saveODocumentCommand);
        this.propertiesStructureTable.addCommand((Command)new CompleteTaskCommand(this.propertiesStructureTable, (IModel<ODocument>)this.getModel(), (IModel<DisplayMode>)this.getModeModel(), this.formKey));
    }

    @Override
    protected FormKey obtainFormKey() {
        ProcessEngine processEngine = BpmPlatform.getDefaultProcessEngine();
        TaskService taskService = processEngine.getTaskService();
        Task task = (Task)taskService.createTaskQuery().taskId((String)((ODocument)this.getModelObject()).field("id")).initializeFormKeys().singleResult();
        return FormKey.parse(task.getFormKey());
    }

    @Override
    protected ODocument resolveODocument(FormKey formKey) {
        return formKey.calculateODocument(BpmPlatform.getDefaultProcessEngine(), (String)((ODocument)this.getModelObject()).field("id"));
    }

    protected void associateTaskWithDocument() {
        this.associateTaskWithDocument((String)((ODocument)this.getModelObject()).field("id"), (ODocument)this.formDocumentModel.getObject());
    }

    protected void associateTaskWithDocument(String taskId, ODocument doc) {
        ProcessEngine processEngine = BpmPlatform.getDefaultProcessEngine();
        TaskService taskService = processEngine.getTaskService();
        String var = this.formKey.getVariableName();
        taskService.setVariable(taskId, var, (Object)doc.getIdentity().toString());
    }

    @Override
    protected IModel<String> getDefaultTitleModel() {
        return new NvlModel((IModel)new PropertyModel((Object)this.getModel(), "name"), (IModel)new ResourceModel("widget.form"));
    }
}

