/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.camel.component;

import java.util.EventObject;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelEventHandler
extends EventNotifierSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CamelEventHandler.class);
    private String logId;

    public CamelEventHandler(String logId) {
        this.logId = logId;
    }

    public void notify(EventObject event) throws Exception {
        if (event instanceof ExchangeSentEvent) {
            ExchangeSentEvent sent = (ExchangeSentEvent)event;
            String logRecord = "Took " + sent.getTimeTaken() + " millis to send to: " + sent.getEndpoint();
            LOG.info(logRecord);
        }
        LOG.info("Event = " + event);
    }

    public boolean isEnabled(EventObject event) {
        return true;
    }

    public void onAllRoutesComplete() {
    }
}

