/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.camel.component;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.orienteer.camel.component.OrientDBEndpoint;

public class OrientDBConsumer
extends DefaultConsumer {
    public OrientDBConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    protected void doStart() throws Exception {
        OrientDBEndpoint endpoint = (OrientDBEndpoint)this.getEndpoint();
        ODatabaseDocument db = endpoint.databaseOpen();
        Object dbResult = db.command((OCommandRequest)new OCommandSQL(endpoint.getSQLQuery())).execute(new Object[0]);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody(endpoint.makeOutObject(dbResult));
        this.getProcessor().process(exchange);
        super.doStart();
        endpoint.databaseClose(db);
    }
}

