/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.camel.component;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.wicket.util.string.Strings;
import org.orienteer.camel.component.OrientDBCamelDataType;
import org.orienteer.camel.component.OrientDBConsumer;
import org.orienteer.camel.component.OrientDBProducer;

@UriEndpoint(scheme="orientdb", syntax="orientdb:sqlQuery", title="OrientDB")
public class OrientDBEndpoint
extends DefaultEndpoint {
    private String remaining;
    private Map<String, Object> parameters;
    @UriParam(defaultValue="map")
    private OrientDBCamelDataType outputType = OrientDBCamelDataType.map;
    @UriParam
    private String fetchPlan;
    @UriParam(defaultValue="0")
    private int maxDepth = 0;
    @UriParam(defaultValue="true")
    private boolean fetchAllEmbedded = true;
    @UriParam
    private String inputAsOClass;
    @UriParam(defaultValue="false")
    private boolean preload = false;
    @UriParam(defaultValue="true")
    private boolean makeNew = true;

    protected OrientDBEndpoint(String endpointUri, Component component, String remaining, Map<String, Object> parameters) {
        super(endpointUri, component);
        this.remaining = remaining;
        this.parameters = parameters;
    }

    protected OrientDBEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public Producer createProducer() throws Exception {
        return new OrientDBProducer((Endpoint)this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new OrientDBConsumer((Endpoint)this, processor);
    }

    public boolean isSingleton() {
        return false;
    }

    public String getSQLQuery() {
        return this.remaining;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public ODatabaseDocument databaseOpen() {
        ODatabaseDocumentInternal currentDatabase = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (currentDatabase != null) {
            return currentDatabase;
        }
        String url = this.getCamelContext().getProperty("orientdb.url");
        String username = this.getCamelContext().getProperty("orientdb.username");
        String password = this.getCamelContext().getProperty("orientdb.password");
        ODatabaseDocumentTx db = (ODatabaseDocumentTx)new ODatabaseDocumentTx(url).open(username, password);
        return db;
    }

    public void databaseClose(ODatabaseDocument db) {
        db.close();
    }

    public Object makeOutObject(Object rawOut) throws Exception {
        if (rawOut instanceof Iterable) {
            ArrayList<Object> resultArray = new ArrayList<Object>();
            Iterable tmpset = (Iterable)rawOut;
            for (Object object : tmpset) {
                if (object instanceof ODocument) {
                    ODocument doc = (ODocument)object;
                    if (this.outputType.equals((Object)OrientDBCamelDataType.map)) {
                        resultArray.add(this.toMap(doc));
                        continue;
                    }
                    if (this.outputType.equals((Object)OrientDBCamelDataType.json)) {
                        resultArray.add(this.toJSON(doc));
                        continue;
                    }
                    if (this.outputType.equals((Object)OrientDBCamelDataType.object)) {
                        resultArray.add(this.toObject(doc));
                        continue;
                    }
                    if (this.outputType.equals((Object)OrientDBCamelDataType.list)) {
                        resultArray.add(this.toList(doc));
                        continue;
                    }
                    throw new Exception("Unknown outputType :" + this.outputType.toString());
                }
                throw new Exception("Unknown type of OrientDB object:" + object.getClass());
            }
            if (this.outputType.equals((Object)OrientDBCamelDataType.json)) {
                return "[" + Strings.join((String)",", resultArray) + "]";
            }
            return resultArray;
        }
        return rawOut;
    }

    private Object toJSON(ODocument obj) {
        if (Strings.isEmpty((CharSequence)this.getFetchPlan())) {
            return obj.toJSON();
        }
        return obj.toJSON("fetchPlan:" + this.getFetchPlan());
    }

    private Object toObject(Object obj) {
        return obj;
    }

    private Object toList(Object obj) {
        if (obj instanceof ODocument) {
            ODocument objDoc = (ODocument)obj;
            ArrayList<String> result = new ArrayList<String>();
            for (Object value : objDoc.fieldValues()) {
                if (value instanceof ODocument) {
                    result.add(((ODocument)value).toJSON());
                    continue;
                }
                result.add(value.toString());
            }
            return result;
        }
        return obj;
    }

    private Object toMap(Object obj) {
        return this.toMap(obj, 0);
    }

    private Object toMap(Object obj, int depth) {
        if (obj instanceof ODocument) {
            String className;
            ORID id;
            ODocument objDoc = (ODocument)obj;
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (objDoc.isEmbedded() && this.isFetchAllEmbedded() || depth <= this.getMaxDepth()) {
                for (String fieldName : objDoc.fieldNames()) {
                    result.put(fieldName, this.toMap(objDoc.field(fieldName), depth + 1));
                }
            }
            if ((id = objDoc.getIdentity()).isValid() && id.isPersistent()) {
                result.put("@rid", id.toString());
            }
            if ((className = objDoc.getClassName()) != null) {
                result.put("@class", className);
            }
            return result;
        }
        if (obj instanceof Map) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Map source = (Map)obj;
            for (Map.Entry entry : source.entrySet()) {
                result.put((String)entry.getKey(), this.toMap(entry.getValue(), depth + 1));
            }
            return result;
        }
        if (obj instanceof Iterable) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object subfield : (Iterable)obj) {
                result.add(this.toMap(subfield, depth + 1));
            }
            return result;
        }
        return obj;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public void setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
    }

    public String getInputAsOClass() {
        return this.inputAsOClass;
    }

    public void setInputAsOClass(String inputAsOClass) {
        this.inputAsOClass = inputAsOClass;
    }

    public boolean isPreload() {
        return this.preload;
    }

    public void setPreload(boolean preload) {
        this.preload = preload;
    }

    public boolean isMakeNew() {
        return this.makeNew;
    }

    public void setMakeNew(boolean makeNew) {
        this.makeNew = makeNew;
    }

    public OrientDBCamelDataType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(OrientDBCamelDataType outputType) {
        this.outputType = outputType;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public boolean isFetchAllEmbedded() {
        return this.fetchAllEmbedded;
    }

    public void setFetchAllEmbedded(boolean fetchAllEmbedded) {
        this.fetchAllEmbedded = fetchAllEmbedded;
    }
}

