/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.camel.component;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultProducer;
import org.apache.wicket.util.string.Strings;
import org.orienteer.camel.component.OrientDBEndpoint;

public class OrientDBProducer
extends DefaultProducer {
    public OrientDBProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        OrientDBEndpoint endpoint = (OrientDBEndpoint)this.getEndpoint();
        ODatabaseDocument db = endpoint.databaseOpen();
        Object input = exchange.getIn().getBody();
        Message out = exchange.getOut();
        out.getHeaders().putAll(exchange.getIn().getHeaders());
        if (input instanceof List) {
            out.setBody(endpoint.makeOutObject(this.processList((List)input, endpoint, db)));
        } else if (input instanceof String && this.isJSONList((String)input)) {
            List<String> inputList = this.strToJSONsList((String)input);
            out.setBody(endpoint.makeOutObject(this.processList(inputList, endpoint, db)));
        } else {
            out.setBody(endpoint.makeOutObject(this.processSingleObject(input, endpoint, db)));
        }
        endpoint.databaseClose(db);
    }

    private boolean isJSONList(String input) {
        return input.matches("^\\[\\{.+\\}\\]$");
    }

    private boolean isJsonObject(String input) {
        return input.matches("^\\{.*\\}$");
    }

    private List<String> strToJSONsList(String str) {
        ArrayList<String> result = new ArrayList<String>();
        double bracketCounter = 0.0;
        double startBracket = -1.0;
        char openb = '{';
        char closeb = '}';
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == openb) {
                bracketCounter += 1.0;
                if (startBracket != -1.0) continue;
                startBracket = i;
                continue;
            }
            if (str.charAt(i) != closeb || startBracket == -1.0 || (bracketCounter -= 1.0) != 0.0) continue;
            result.add(str.substring((int)startBracket, i + 1));
            startBracket = -1.0;
        }
        return result;
    }

    private List<Object> processList(List<?> inputList, OrientDBEndpoint endpoint, ODatabaseDocument db) throws Exception {
        ArrayList<Object> outputList = new ArrayList<Object>();
        for (Object inputElement : inputList) {
            Object dbResult = this.processSingleObject(inputElement, endpoint, db);
            if (dbResult instanceof List) {
                outputList.addAll((List)dbResult);
                continue;
            }
            outputList.add(dbResult);
        }
        return outputList;
    }

    private Object processSingleObject(Object input, OrientDBEndpoint endpoint, ODatabaseDocument db) throws Exception {
        ODocument inputDocument = null;
        if (input instanceof Map) {
            inputDocument = (ODocument)this.fromMap(input);
        } else if (input instanceof ODocument) {
            inputDocument = this.fromObject((ODocument)input, endpoint, db);
        } else if (input instanceof String && this.isJsonObject((String)input)) {
            inputDocument = this.fromJSON((String)input, endpoint, db);
        }
        if (inputDocument != null) {
            if (!Strings.isEmpty((CharSequence)endpoint.getInputAsOClass())) {
                inputDocument.setClassName(endpoint.getInputAsOClass());
            }
            if (endpoint.isMakeNew()) {
                inputDocument.getIdentity().reset();
            }
            if (endpoint.isPreload()) {
                inputDocument.save();
            }
            if (!Strings.isEmpty((CharSequence)endpoint.getSQLQuery())) {
                Object dbResult = db.command((OCommandRequest)new OCommandSQL(endpoint.getSQLQuery())).execute(new Object[]{inputDocument.toMap()});
                return dbResult;
            }
            return inputDocument;
        }
        if (!Strings.isEmpty((CharSequence)endpoint.getSQLQuery())) {
            if (input instanceof List) {
                this.convertLinks((List)input);
                Object dbResult = db.command((OCommandRequest)new OCommandSQL(endpoint.getSQLQuery())).execute(((List)input).toArray());
                return dbResult;
            }
            Object dbResult = db.command((OCommandRequest)new OCommandSQL(endpoint.getSQLQuery())).execute(new Object[]{input});
            return dbResult;
        }
        return input;
    }

    private void convertLinks(List<Object> input) {
        for (int i = 0; i < input.size(); ++i) {
            if (!input.get(i).toString().matches("^#[\\d]+:[\\d]+$")) continue;
            input.set(i, new ORecordId(input.get(i).toString()));
        }
    }

    private Object fromMap(Object input) {
        if (input instanceof Map) {
            Map objMap = (Map)input;
            String rid = (String)objMap.remove("@rid");
            String clazz = (String)objMap.remove("@class");
            if (rid != null || clazz != null) {
                ODocument result = null;
                if (rid != null && clazz != null && objMap.isEmpty()) {
                    result = new ODocument(clazz, (ORID)new ORecordId(rid));
                } else if (clazz != null && (rid == null || ((OrientDBEndpoint)this.getEndpoint()).isMakeNew())) {
                    result = new ODocument(clazz);
                } else if (rid != null && clazz != null) {
                    result = new ODocument(clazz, (ORID)new ORecordId(rid));
                } else if (rid != null) {
                    result = new ODocument((ORID)new ORecordId(rid));
                }
                for (Map.Entry entry : objMap.entrySet()) {
                    result.field((String)entry.getKey(), this.fromMap(entry.getValue()));
                }
                return result;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : objMap.entrySet()) {
                result.put((String)entry.getKey(), this.fromMap(entry.getValue()));
            }
            return result;
        }
        if (input instanceof Iterable) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object item : (Iterable)input) {
                result.add(this.fromMap(item));
            }
            return result;
        }
        return input;
    }

    private ODocument fromJSON(String input, OrientDBEndpoint endpoint, ODatabaseDocument db) {
        ODocument out = new ODocument();
        out.fromJSON(input);
        return out;
    }

    private ODocument fromObject(ODocument input, OrientDBEndpoint endpoint, ODatabaseDocument db) {
        return input;
    }
}

