/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.camel.widget;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.UnauthorizedActionException;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.orienteer.camel.component.CamelEventHandler;
import org.orienteer.core.component.BootstrapType;
import org.orienteer.core.component.FAIcon;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.command.AjaxCommand;
import org.orienteer.core.component.command.Command;
import org.orienteer.core.component.structuretable.OrienteerStructureTable;
import org.orienteer.core.widget.AbstractWidget;
import org.orienteer.core.widget.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ydn.wicket.wicketorientdb.IOrientDbSettings;
import ru.ydn.wicket.wicketorientdb.OrientDbWebApplication;
import ru.ydn.wicket.wicketorientdb.OrientDbWebSession;
import ru.ydn.wicket.wicketorientdb.model.SimpleNamingModel;

@Widget(domain="document", selector="OIntegrationConfig", id="camelIntegration", order=20, autoEnable=true)
public class CamelWidget
extends AbstractWidget<ODocument> {
    public static final String WIDGET_TYPE_ID = "camelIntegration";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CamelWidget.class);
    public static final MetaDataKey<Map<String, CamelContext>> INTEGRATION_SESSIONS_KEY = new MetaDataKey<Map<String, CamelContext>>(){
        private static final long serialVersionUID = 1L;
    };
    private Form form = new Form("form");
    public static final List<String> CONTEXT_DATA_LIST = new ArrayList<String>();

    public CamelWidget(String id, IModel<ODocument> model, IModel<ODocument> widgetDocumentModel) {
        super(id, model, widgetDocumentModel);
        OrienteerStructureTable<CamelContext, String> structuredTable = new OrienteerStructureTable<CamelContext, String>("table", (IModel)new CamelContextModel(), CONTEXT_DATA_LIST){
            private static final long serialVersionUID = 1L;

            protected Component getValueComponent(String id, IModel<String> rowModel) {
                return new Label(id, (IModel)new PropertyModel((Object)this.getModel(), (String)rowModel.getObject()));
            }

            protected IModel<?> getLabelModel(Component resolvedComponent, IModel<String> rowModel) {
                return new SimpleNamingModel((Object)("integration." + (String)rowModel.getObject()));
            }
        };
        this.form.add(new Component[]{structuredTable});
        structuredTable.addCommand(this.makeStartButton());
        structuredTable.addCommand(this.makeStopButton());
        structuredTable.addCommand(this.makeSuspendButton());
        this.form.setOutputMarkupId(true);
        this.add(new Component[]{this.form});
    }

    private Command makeStartButton() {
        return new AjaxCommand("start", "integration.start"){

            protected void onInitialize() {
                super.onInitialize();
                this.setIcon(FAIconType.play);
                this.setBootstrapType(BootstrapType.SUCCESS);
                this.setChangingDisplayMode(true);
            }

            public void onClick(AjaxRequestTarget target) {
                try {
                    ODocument doc = (ODocument)CamelWidget.this.getDefaultModelObject();
                    CamelContext context = CamelWidget.this.getOrMakeContextByRid(doc.getIdentity().toString());
                    if (context.getStatus().isSuspended()) {
                        context.resume();
                        target.add(new Component[]{CamelWidget.this.form});
                    } else if (!context.getStatus().isStarted()) {
                        CamelWidget.this.clearContext(context);
                        String script = (String)doc.field("script");
                        RoutesDefinition routes = context.loadRoutesDefinition((InputStream)new ByteArrayInputStream(script.getBytes()));
                        context.addRouteDefinitions((Collection)routes.getRoutes());
                        context.start();
                        target.add(new Component[]{CamelWidget.this.form});
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public boolean isEnabled() {
                CamelContext context = CamelWidget.this.getOrMakeContext();
                ServiceStatus status = context.getStatus();
                if (status.isStarted()) {
                    return false;
                }
                return super.isEnabled();
            }
        };
    }

    private Command makeSuspendButton() {
        return new AjaxCommand("suspend", "integration.suspend"){

            protected void onInitialize() {
                super.onInitialize();
                this.setIcon(FAIconType.pause);
                this.setBootstrapType(BootstrapType.WARNING);
                this.setChangingDisplayMode(true);
            }

            public void onClick(AjaxRequestTarget target) {
                try {
                    CamelContext context = CamelWidget.this.getOrMakeContext();
                    ServiceStatus status = context.getStatus();
                    if (status.isSuspended()) {
                        context.start();
                    } else if (status.isStarted()) {
                        context.suspend();
                    }
                    target.add(new Component[]{CamelWidget.this.form});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public boolean isEnabled() {
                CamelContext context = CamelWidget.this.getOrMakeContext();
                ServiceStatus status = context.getStatus();
                if (!status.isStarted()) {
                    return false;
                }
                return super.isEnabled();
            }
        };
    }

    private Command makeStopButton() {
        return new AjaxCommand("stop", "integration.stop"){

            protected void onInitialize() {
                super.onInitialize();
                this.setIcon(FAIconType.stop);
                this.setBootstrapType(BootstrapType.DANGER);
                this.setChangingDisplayMode(true);
            }

            public void onClick(AjaxRequestTarget target) {
                CamelContext context = CamelWidget.this.getOrMakeContext();
                try {
                    context.stop();
                    target.add(new Component[]{CamelWidget.this.form});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public boolean isEnabled() {
                CamelContext context = CamelWidget.this.getOrMakeContext();
                ServiceStatus status = context.getStatus();
                if (status.isStopped()) {
                    return false;
                }
                return super.isEnabled();
            }
        };
    }

    private CamelContext getOrMakeContext() {
        ODocument doc = (ODocument)this.getDefaultModelObject();
        return this.getOrMakeContextByRid(doc.getIdentity().toString());
    }

    private CamelContext getOrMakeContextByRid(String rid) {
        CamelContext context;
        Map contextMap = (Map)this.getApplication().getMetaData(INTEGRATION_SESSIONS_KEY);
        if (contextMap.containsKey(rid)) {
            context = (CamelContext)contextMap.get(rid);
        } else {
            IOrientDbSettings dbSettings = OrientDbWebApplication.get().getOrientDbSettings();
            OrientDbWebSession session = OrientDbWebSession.get();
            if (session.getUsername() == null) {
                throw new UnauthorizedActionException((Component)this, Component.RENDER);
            }
            context = new DefaultCamelContext();
            Map properties = context.getProperties();
            properties.put("orientdb.url", dbSettings.getDBUrl());
            properties.put("orientdb.username", session.getUsername());
            properties.put("orientdb.password", session.getPassword());
            context.setProperties(properties);
            context.getManagementStrategy().addEventNotifier((EventNotifier)new CamelEventHandler(""));
            contextMap.put(rid, context);
        }
        return context;
    }

    private void clearContext(CamelContext context) throws Exception {
        List definitions = context.getRouteDefinitions();
        if (!definitions.isEmpty()) {
            context.removeRouteDefinitions(new ArrayList(definitions));
        }
    }

    protected FAIcon newIcon(String id) {
        return new FAIcon(id, FAIconType.bars);
    }

    protected IModel<String> getDefaultTitleModel() {
        return new ResourceModel("integration.camel");
    }

    protected String getWidgetStyleClass() {
        return "strict";
    }

    static {
        CONTEXT_DATA_LIST.add("name");
        CONTEXT_DATA_LIST.add("status");
        CONTEXT_DATA_LIST.add("uptime");
        CONTEXT_DATA_LIST.add("version");
    }

    private class CamelContextModel
    extends LoadableDetachableModel<CamelContext> {
        private static final long serialVersionUID = 1L;

        private CamelContextModel() {
        }

        protected CamelContext load() {
            return CamelWidget.this.getOrMakeContext();
        }
    }
}

