/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.camel.tasks;

import java.util.EventObject;
import org.apache.camel.CamelContext;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.orienteer.camel.component.OIntegrationConfig;
import org.orienteer.camel.tasks.OCamelTaskSession;
import org.orienteer.core.tasks.ITaskSessionCallback;
import org.orienteer.core.tasks.OTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelEventHandler
extends EventNotifierSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CamelEventHandler.class);
    private ITaskSessionCallback callback;
    private volatile OCamelTaskSession taskSession;
    private OIntegrationConfig config;
    private CamelContext context;

    public CamelEventHandler(ITaskSessionCallback callback, OIntegrationConfig config, CamelContext context) {
        this.callback = callback;
        this.config = config;
        this.context = context;
    }

    public void notify(EventObject event) throws Exception {
        if (event instanceof ExchangeSentEvent) {
            ExchangeSentEvent sent = (ExchangeSentEvent)event;
            String logRecord = "Took " + sent.getTimeTaken() + " millis to send to: " + sent.getEndpoint();
            this.taskSession.incrementCurrentProgress();
        }
        this.taskSession.appendOut(event.toString());
    }

    public boolean isEnabled(EventObject event) {
        return true;
    }

    public void onAllRoutesComplete() {
        if (this.taskSession != null) {
            this.taskSession.finish();
            this.taskSession = null;
        }
    }

    protected void doStart() throws Exception {
        LOG.info(Thread.currentThread().getName());
        this.taskSession = new OCamelTaskSession();
        this.taskSession.setOTask(this.config);
        this.taskSession.setCallback(this.callback);
        Object deleteOnFinish = this.config.getDocument().field(OTask.Field.AUTODELETE_SESSIONS.fieldName());
        this.taskSession.setDeleteOnFinish(deleteOnFinish != null ? (Boolean)deleteOnFinish : false);
        this.taskSession.setConfig(this.config.getDocument().getIdentity().toString());
        this.taskSession.setFinalProgress(this.context.getRoutes().size());
        this.taskSession.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.taskSession != null) {
            this.taskSession.interrupt();
        }
        super.doStop();
    }
}

