/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.camel.tasks;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.tasks.ITaskSession;
import org.orienteer.core.tasks.OTaskSessionRuntime;
import org.orienteer.core.util.OSchemaHelper;

public class OCamelTaskSession
extends OTaskSessionRuntime {
    public static final String TASK_SESSION_CLASS = "OCamelTaskSession";

    public static final void onInstallModule(OrienteerWebApplication app, ODatabaseDocument db) {
        OSchemaHelper helper = OSchemaHelper.bind((ODatabaseDocument)db);
        helper.oClass(TASK_SESSION_CLASS, new String[]{"OTaskSession"});
        helper.oProperty(ITaskSession.Field.THREAD_NAME.fieldName(), OType.STRING, 10).markAsDocumentName();
        helper.oProperty(Field.CONFIG.fieldName(), Field.CONFIG.type(), 35).markAsLinkToParent();
        helper.oProperty(Field.OUTPUT.fieldName(), Field.OUTPUT.type(), 37).assignVisualization("textarea");
    }

    public OCamelTaskSession() {
        super(TASK_SESSION_CLASS, true);
    }

    public OCamelTaskSession(String sessionClass) {
        super(sessionClass, true);
    }

    public OCamelTaskSession appendOut(String out) {
        out = this.getOTaskSessionPersisted().getDocument().field(Field.OUTPUT.fieldName()) + out + "\n";
        this.getOTaskSessionPersisted().persist(Field.OUTPUT.fieldName(), (Object)out);
        return this;
    }

    public OCamelTaskSession setConfig(String configId) {
        this.getOTaskSessionPersisted().persist(Field.CONFIG.fieldName(), (Object)new ORecordId(configId));
        return this;
    }

    public static enum Field {
        OUTPUT("out", OType.STRING),
        CONFIG("config", OType.LINK);

        private String fieldName;
        private OType type;

        public String fieldName() {
            return this.fieldName;
        }

        public OType type() {
            return this.type;
        }

        private Field(String fieldName, OType type) {
            this.fieldName = fieldName;
            this.type = type;
        }
    }
}

