/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.camel;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.concurrent.ConcurrentHashMap;
import org.orienteer.camel.component.OIntegrationConfig;
import org.orienteer.camel.tasks.OCamelTaskSession;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.method.OMethodsManager;
import org.orienteer.core.module.AbstractOrienteerModule;
import org.orienteer.core.util.OSchemaHelper;

public class Module
extends AbstractOrienteerModule {
    protected Module() {
        super("camel", 2);
    }

    public ODocument onInstall(OrienteerWebApplication app, ODatabaseDocument db) {
        super.onInstall(app, db);
        this.makeSchema(app, db);
        return null;
    }

    public void onUpdate(OrienteerWebApplication app, ODatabaseDocument db, int oldVersion, int newVersion) {
        super.onUpdate(app, db, oldVersion, newVersion);
        this.onInstall(app, db);
        db.commit();
        db.command((OCommandRequest)new OCommandSQL("ALTER CLASS OIntegrationConfig SUPERCLASS OTask")).execute(new Object[0]);
    }

    public void onInitialize(OrienteerWebApplication app, ODatabaseDocument db) {
        super.onInitialize(app, db);
        app.setMetaData(OIntegrationConfig.INTEGRATION_SESSIONS_KEY, new ConcurrentHashMap());
        app.mountPages("org.orienteer.camel.web");
        OMethodsManager.get().addModule(Module.class);
        OMethodsManager.get().reload();
    }

    private void makeSchema(OrienteerWebApplication app, ODatabaseDocument db) {
        OSchemaHelper helper = OSchemaHelper.bind((ODatabaseDocument)db);
        helper.oClass("OIntegrationConfig", new String[]{"OTask"}).oProperty("script", OType.STRING, 15).assignVisualization("script");
        OCamelTaskSession.onInstallModule(app, db);
    }

    public void onDestroy(OrienteerWebApplication app, ODatabaseDocument db) {
        super.onDestroy(app, db);
        app.unmountPages("org.orienteer.camel.web");
        OMethodsManager.get().removeModule(Module.class);
        OMethodsManager.get().reload();
    }
}

