/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.camel.component;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.authorization.UnauthorizedActionException;
import org.orienteer.camel.behavior.OIntegrationConfigStopBehavior;
import org.orienteer.camel.tasks.CamelEventHandler;
import org.orienteer.camel.tasks.OCamelTaskSessionCallback;
import org.orienteer.core.component.BootstrapType;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.method.IMethodContext;
import org.orienteer.core.method.OFilter;
import org.orienteer.core.method.OMethod;
import org.orienteer.core.method.filters.PlaceFilter;
import org.orienteer.core.method.filters.WidgetTypeFilter;
import org.orienteer.core.tasks.OTask;
import org.orienteer.core.tasks.OTaskSessionRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ydn.wicket.wicketorientdb.IOrientDbSettings;
import ru.ydn.wicket.wicketorientdb.OrientDbWebApplication;
import ru.ydn.wicket.wicketorientdb.OrientDbWebSession;

public class OIntegrationConfig
extends OTask {
    private static final Logger LOG = LoggerFactory.getLogger(OIntegrationConfig.class);
    private static final long serialVersionUID = 1L;
    public static final String TASK_CLASS = "OIntegrationConfig";
    public static final MetaDataKey<Map<String, CamelContext>> INTEGRATION_SESSIONS_KEY = new MetaDataKey<Map<String, CamelContext>>(){
        private static final long serialVersionUID = 1L;
    };

    @OMethod(order=10, bootstrap=BootstrapType.SUCCESS, icon=FAIconType.play, filters={@OFilter(fClass=PlaceFilter.class, fData="STRUCTURE_TABLE"), @OFilter(fClass=WidgetTypeFilter.class, fData="parameters")})
    public void start(IMethodContext data) {
        final CamelContext context = this.getOrMakeContextByRid(this.getDocument().getIdentity().toString(), (Component)data.getCurrentWidget());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (context.getStatus().isSuspended()) {
                        context.resume();
                    } else if (!context.getStatus().isStarted()) {
                        OIntegrationConfig.this.clearContext(context);
                        String script = (String)OIntegrationConfig.this.getDocument().field("script");
                        RoutesDefinition routes = context.loadRoutesDefinition((InputStream)new ByteArrayInputStream(script.getBytes()));
                        context.addRouteDefinitions((Collection)routes.getRoutes());
                        context.start();
                    }
                }
                catch (Exception e) {
                    LOG.error("Cannot start or resume Camel Context", (Throwable)e);
                }
            }
        }).start();
        this.waitingRefresh(context);
    }

    @OMethod(order=30, bootstrap=BootstrapType.DANGER, icon=FAIconType.stop, filters={@OFilter(fClass=PlaceFilter.class, fData="STRUCTURE_TABLE"), @OFilter(fClass=WidgetTypeFilter.class, fData="parameters")}, behaviors={OIntegrationConfigStopBehavior.class})
    public void stop(IMethodContext data) {
        CamelContext context = this.getOrMakeContextByRid(this.getDocument().getIdentity().toString(), (Component)data.getCurrentWidget());
        try {
            context.stop();
        }
        catch (Exception e) {
            LOG.error("Cannot stop Camel Context", (Throwable)e);
        }
        this.waitingRefresh(context);
    }

    @OMethod(order=20, bootstrap=BootstrapType.WARNING, icon=FAIconType.pause, filters={@OFilter(fClass=PlaceFilter.class, fData="STRUCTURE_TABLE"), @OFilter(fClass=WidgetTypeFilter.class, fData="parameters")}, behaviors={OIntegrationConfigStopBehavior.class})
    public void suspend(IMethodContext data) {
        final CamelContext context = this.getOrMakeContext((Component)data.getCurrentWidget());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ServiceStatus status = context.getStatus();
                    if (status.isSuspended()) {
                        context.start();
                    } else if (status.isStarted()) {
                        context.suspend();
                    }
                }
                catch (Exception e) {
                    LOG.error("Cannot start or suspend Camel Context", (Throwable)e);
                }
            }
        }).start();
        this.waitingRefresh(context);
    }

    public OIntegrationConfig(ODocument doc) {
        super(doc);
    }

    public CamelContext getOrMakeContextByRid(String rid, Component component) {
        CamelContext context;
        Map contextMap = (Map)Application.get().getMetaData(INTEGRATION_SESSIONS_KEY);
        if (contextMap.containsKey(rid)) {
            context = (CamelContext)contextMap.get(rid);
        } else {
            IOrientDbSettings dbSettings = OrientDbWebApplication.get().getOrientDbSettings();
            OrientDbWebSession session = OrientDbWebSession.get();
            if (session.getUsername() == null) {
                throw new UnauthorizedActionException(component, Component.RENDER);
            }
            context = new DefaultCamelContext();
            Map properties = context.getProperties();
            properties.put("orientdb.url", dbSettings.getDBUrl());
            properties.put("orientdb.username", session.getUsername());
            properties.put("orientdb.password", session.getPassword());
            context.setProperties(properties);
            context.getManagementStrategy().addEventNotifier((EventNotifier)new CamelEventHandler(new OCamelTaskSessionCallback(context), this, context));
            contextMap.put(rid, context);
        }
        return context;
    }

    public void clearContext(CamelContext context) throws Exception {
        List definitions = context.getRouteDefinitions();
        if (!definitions.isEmpty()) {
            context.removeRouteDefinitions(new ArrayList(definitions));
        }
    }

    public CamelContext getOrMakeContext(Component component) {
        return this.getOrMakeContextByRid(this.getDocument().getIdentity().toString(), component);
    }

    private void waitingRefresh(CamelContext context) {
        ServiceStatus oldStatus = context.getStatus();
        try {
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(100L);
                if (oldStatus.equals((Object)context.getStatus())) continue;
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public OTaskSessionRuntime startNewSession() {
        throw new RuntimeException("Cannot start new Camel session outside CamelEventHandler");
    }
}

