/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.graph.component.command;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.orienteer.core.component.BootstrapType;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.command.AbstractModalWindowCommand;
import org.orienteer.core.component.command.modal.SelectDialogPanel;
import org.orienteer.core.component.command.modal.SelectSubOClassDialogPage;
import org.orienteer.core.component.table.OrienteerDataTable;
import ru.ydn.wicket.wicketorientdb.model.OClassModel;
import ru.ydn.wicket.wicketorientdb.security.ISecuredComponent;
import ru.ydn.wicket.wicketorientdb.security.OSecurityHelper;
import ru.ydn.wicket.wicketorientdb.security.OrientPermission;
import ru.ydn.wicket.wicketorientdb.security.RequiredOrientResource;

public class CreateEdgeCommand
extends AbstractModalWindowCommand<ODocument>
implements ISecuredComponent {
    private IModel<OClass> classModel;
    private IModel<ODocument> documentModel;

    public CreateEdgeCommand(OrienteerDataTable<ODocument, ?> table, IModel<ODocument> documentIModel) {
        this((IModel<?>)new ResourceModel("command.link"), table, documentIModel);
    }

    public CreateEdgeCommand(IModel<?> labelModel, OrienteerDataTable<ODocument, ?> table, IModel<ODocument> documentIModel) {
        super(labelModel, table);
        this.setBootstrapType(BootstrapType.SUCCESS);
        this.setIcon(FAIconType.plus);
        this.setAutoNotify(false);
        this.classModel = new OClassModel("V");
        this.documentModel = documentIModel;
    }

    protected void initializeContent(final ModalWindow modal) {
        modal.setTitle((IModel)new ResourceModel("dialog.select.edge.class"));
        modal.setAutoSize(true);
        modal.setMinimalWidth(300);
        SelectSubOClassDialogPage selectEdgeClassDialog = new SelectSubOClassDialogPage(modal, (IModel)new OClassModel("E")){

            protected void onSelect(AjaxRequestTarget target, final OClass selectedOClass) {
                modal.setTitle((IModel)new ResourceModel("dialog.select.vertices"));
                OClassModel vertexOClassModel = new OClassModel("V");
                modal.setContent((Component)new SelectDialogPanel(modal.getContentId(), modal, (IModel)vertexOClassModel, true){

                    protected boolean onSelect(AjaxRequestTarget target, List<ODocument> objects, boolean selectMore) {
                        CreateEdgeCommand.this.createEdge(objects, selectedOClass);
                        modal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
                            private static final long serialVersionUID = 1L;

                            public void onClose(AjaxRequestTarget target) {
                                target.add(new Component[]{this.getPage()});
                            }
                        });
                        return true;
                    }
                });
                modal.show((IPartialPageRequestHandler)target);
            }
        };
        modal.setContent((Component)selectEdgeClassDialog);
    }

    public RequiredOrientResource[] getRequiredResources() {
        return OSecurityHelper.requireOClass((OClass)((OClass)this.classModel.getObject()), (OrientPermission[])new OrientPermission[]{OrientPermission.CREATE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEdge(List<ODocument> documents, OClass edgeClass) {
        OrientGraph tx = null;
        try {
            tx = new OrientGraphFactory(this.getDatabase().getURL()).getTx();
            for (ODocument createTo : documents) {
                tx.addEdge(null, (Vertex)tx.getVertex((Object)((ODocument)this.documentModel.getObject()).getIdentity()), (Vertex)tx.getVertex((Object)createTo.getIdentity()), edgeClass.getName());
            }
        }
        finally {
            if (tx != null) {
                tx.shutdown();
            }
        }
    }
}

