/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.graph.component.command;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.orienteer.core.component.BootstrapType;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.command.AbstractModalWindowCommand;
import org.orienteer.core.component.command.modal.SelectSubOClassDialogPage;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.component.table.OrienteerDataTable;
import org.orienteer.core.web.ODocumentPage;
import ru.ydn.wicket.wicketorientdb.model.OClassModel;
import ru.ydn.wicket.wicketorientdb.model.ODocumentModel;
import ru.ydn.wicket.wicketorientdb.security.ISecuredComponent;
import ru.ydn.wicket.wicketorientdb.security.OSecurityHelper;
import ru.ydn.wicket.wicketorientdb.security.OrientPermission;
import ru.ydn.wicket.wicketorientdb.security.RequiredOrientResource;

public class CreateVertexCommand
extends AbstractModalWindowCommand<ODocument>
implements ISecuredComponent {
    private IModel<OClass> classModel;
    private IModel<ODocument> documentModel;

    public CreateVertexCommand(OrienteerDataTable<ODocument, ?> table, IModel<ODocument> documentIModel) {
        super((IModel)new ResourceModel("command.create"), table);
        this.setBootstrapType(BootstrapType.PRIMARY);
        this.setIcon(FAIconType.plus);
        this.setAutoNotify(false);
        this.classModel = new OClassModel("V");
        this.documentModel = documentIModel;
    }

    protected void initializeContent(final ModalWindow modal) {
        modal.setTitle((IModel)new ResourceModel("dialog.select.vertex.class"));
        modal.setAutoSize(true);
        modal.setMinimalWidth(300);
        SelectSubOClassDialogPage selectVertexClassDialog = new SelectSubOClassDialogPage(modal, (IModel)new OClassModel("V")){

            protected void onSelect(AjaxRequestTarget target, final OClass selectedOVertexClass) {
                modal.setTitle((IModel)new ResourceModel("dialog.select.edge.class"));
                OClassModel edgeOClassModel = new OClassModel("E");
                modal.setContent((Component)new SelectSubOClassDialogPage(modal, (IModel)edgeOClassModel){

                    protected void onSelect(AjaxRequestTarget target, OClass selectedOEdgeClass) {
                        CreateVertexCommand.this.createVertex(selectedOVertexClass, selectedOEdgeClass);
                        modal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
                            private static final long serialVersionUID = 1L;

                            public void onClose(AjaxRequestTarget target) {
                                this.setResponsePage((IRequestablePage)new ODocumentPage((IModel)new ODocumentModel((ODocument)CreateVertexCommand.this.documentModel.getObject())).setModeObject(DisplayMode.VIEW));
                            }
                        });
                    }
                });
                modal.show((IPartialPageRequestHandler)target);
            }
        };
        modal.setContent((Component)selectVertexClassDialog);
    }

    public RequiredOrientResource[] getRequiredResources() {
        return OSecurityHelper.requireOClass((OClass)((OClass)this.classModel.getObject()), (OrientPermission[])new OrientPermission[]{OrientPermission.CREATE});
    }

    private void createVertex(OClass vertexClass, OClass edgeClass) {
        OrientGraph tx = new OrientGraphFactory(this.getDatabase().getURL()).getTx();
        OrientVertex newVertex = tx.addVertex(vertexClass.getName(), (String)null);
        OrientVertex vertex = tx.getVertex((Object)((ODocument)this.documentModel.getObject()).getIdentity());
        tx.addEdge(null, (Vertex)vertex, (Vertex)newVertex, edgeClass.getName());
    }
}

