/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.graph.component.command;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.orienteer.core.component.BootstrapType;
import org.orienteer.core.component.command.AbstractDeleteCommand;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.component.table.OrienteerDataTable;
import org.orienteer.core.web.ODocumentPage;
import ru.ydn.wicket.wicketorientdb.model.OClassModel;
import ru.ydn.wicket.wicketorientdb.security.ISecuredComponent;
import ru.ydn.wicket.wicketorientdb.security.OSecurityHelper;
import ru.ydn.wicket.wicketorientdb.security.OrientPermission;
import ru.ydn.wicket.wicketorientdb.security.RequiredOrientResource;

public class UnlinkVertexCommand
extends AbstractDeleteCommand<ODocument>
implements ISecuredComponent {
    private static final long serialVersionUID = 1L;
    private IModel<OClass> classModel;
    private IModel<ODocument> documentModel;

    public UnlinkVertexCommand(OrienteerDataTable<ODocument, ?> table, IModel<ODocument> documentModel) {
        super((IModel)new ResourceModel("command.unlink"), table);
        this.setBootstrapType(BootstrapType.WARNING);
        this.documentModel = documentModel;
        this.classModel = new OClassModel("E");
    }

    protected void performMultiAction(AjaxRequestTarget target, List<ODocument> objects) {
        super.performMultiAction(target, objects);
        OrientGraph tx = new OrientGraphFactory(this.getDatabase().getURL()).getTx();
        tx.commit();
        for (ODocument doc : objects) {
            ORID id = doc.getIdentity();
            OrientVertex vertex = tx.getVertex((Object)id);
            this.removeEdges(tx, vertex);
        }
        tx.begin();
        this.setResponsePage((IRequestablePage)new ODocumentPage((ODocument)this.documentModel.getObject()).setModeObject(DisplayMode.VIEW));
    }

    private void removeEdges(OrientGraph tx, OrientVertex vertex) {
        OrientVertex destination = tx.getVertex((Object)((ODocument)this.documentModel.getObject()).getIdentity());
        Iterable edges = vertex.getEdges(destination, Direction.BOTH, new String[0]);
        for (Edge edge : edges) {
            tx.removeEdge(edge);
        }
    }

    public RequiredOrientResource[] getRequiredResources() {
        return OSecurityHelper.requireOClass((OClass)((OClass)this.classModel.getObject()), (OrientPermission[])new OrientPermission[]{OrientPermission.DELETE});
    }
}

