/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.graph.component.widget;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.orienteer.core.behavior.UpdateOnActionPerformedEventBehavior;
import org.orienteer.core.component.FAIcon;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.component.table.ODocumentDescriptionColumn;
import org.orienteer.core.component.table.OEntityColumn;
import org.orienteer.core.component.table.OrienteerDataTable;
import org.orienteer.core.model.ODocumentNameModel;
import org.orienteer.core.service.impl.OClassIntrospector;
import org.orienteer.core.widget.AbstractWidget;
import org.orienteer.core.widget.Widget;
import ru.ydn.wicket.wicketorientdb.behavior.DisableIfDocumentNotSavedBehavior;
import ru.ydn.wicket.wicketorientdb.model.OQueryDataProvider;

@Widget(id="vertices", domain="document", order=10, autoEnable=true, selector="E")
public class GraphVerticesWidget
extends AbstractWidget<ODocument> {
    @Inject
    private OClassIntrospector oClassIntrospector;

    public GraphVerticesWidget(String id, final IModel<ODocument> model, IModel<ODocument> widgetDocumentModel) {
        super(id, model, widgetDocumentModel);
        IModel modeModel = DisplayMode.VIEW.asModel();
        Form form = new Form("form");
        OProperty nameProperty = this.oClassIntrospector.getNameProperty(((ODocument)this.getModelObject()).getSchemaClass());
        OEntityColumn entityColumn = new OEntityColumn(nameProperty, true, modeModel);
        Function<ODocument, String> directionLocalizer = new Function<ODocument, String>(){

            public String apply(ODocument vertex) {
                Object fieldIn = ((ODocument)model.getObject()).field("in");
                String direction = ((OIdentifiable)fieldIn).getIdentity().equals(vertex.getIdentity()) ? "in" : "out";
                return GraphVerticesWidget.this.getLocalizer().getString("widget.document.vertices.title." + direction, (Component)GraphVerticesWidget.this);
            }
        };
        ODocumentDescriptionColumn directionColumn = new ODocumentDescriptionColumn((IModel)new StringResourceModel("property.direction", (Component)this, (IModel)Model.of()), (Function)directionLocalizer);
        OrienteerDataTable<ODocument, String> table = new OrienteerDataTable<ODocument, String>("vertices", (List)Lists.newArrayList((Object[])new AbstractColumn[]{entityColumn, directionColumn}), (ISortableDataProvider)new OQueryDataProvider("select from [" + ((OIdentifiable)((ODocument)model.getObject()).field("in")).getIdentity() + "," + ((OIdentifiable)((ODocument)model.getObject()).field("out")).getIdentity() + "]"), 2){};
        form.add(new Component[]{table});
        this.add(new Component[]{form});
        this.add(new Behavior[]{DisableIfDocumentNotSavedBehavior.INSTANCE, UpdateOnActionPerformedEventBehavior.INSTANCE_ALL_CONTINUE});
    }

    protected FAIcon newIcon(String id) {
        return new FAIcon(id, FAIconType.arrows_h);
    }

    protected IModel<String> getDefaultTitleModel() {
        return new StringResourceModel("widget.document.vertices.title", (IModel)new ODocumentNameModel(this.getModel()));
    }
}

