/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.graph.component.command;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.orienteer.core.component.command.AbstractDeleteCommand;
import org.orienteer.core.component.table.OrienteerDataTable;
import ru.ydn.wicket.wicketorientdb.model.OClassModel;
import ru.ydn.wicket.wicketorientdb.security.ISecuredComponent;
import ru.ydn.wicket.wicketorientdb.security.OSecurityHelper;
import ru.ydn.wicket.wicketorientdb.security.OrientPermission;
import ru.ydn.wicket.wicketorientdb.security.RequiredOrientResource;

public class DeleteEdgeCommand
extends AbstractDeleteCommand<ODocument>
implements ISecuredComponent {
    private static final long serialVersionUID = 1L;
    private IModel<OClass> classModel;
    private IModel<ODocument> documentModel;
    @Inject
    private Provider<OrientGraph> orientGraphProvider;

    public DeleteEdgeCommand(OrienteerDataTable<ODocument, ?> table, IModel<ODocument> documentModel) {
        super((IModel)new ResourceModel("command.delete"), table);
        this.documentModel = documentModel;
        this.classModel = new OClassModel("E");
        this.setChandingModel(true);
    }

    protected void performMultiAction(AjaxRequestTarget target, List<ODocument> objects) {
        OrientGraph tx = (OrientGraph)this.orientGraphProvider.get();
        for (ODocument doc : objects) {
            ORID id = doc.getIdentity();
            OrientEdge edge = tx.getEdge((Object)id);
            tx.removeEdge((Edge)edge);
        }
        tx.commit();
        tx.begin();
        this.sendActionPerformed();
    }

    public RequiredOrientResource[] getRequiredResources() {
        return OSecurityHelper.requireOClass((OClass)((OClass)this.classModel.getObject()), (OrientPermission[])new OrientPermission[]{OrientPermission.DELETE});
    }

    public void detachModels() {
        super.detachModels();
        this.classModel.detach();
        this.documentModel.detach();
    }
}

