/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.graph.component.widget;

import com.google.inject.Inject;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.orienteer.core.behavior.UpdateOnActionPerformedEventBehavior;
import org.orienteer.core.component.BootstrapType;
import org.orienteer.core.component.FAIcon;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.command.Command;
import org.orienteer.core.component.command.EditODocumentsCommand;
import org.orienteer.core.component.command.SaveODocumentsCommand;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.component.property.LinkViewPanel;
import org.orienteer.core.component.table.OrienteerDataTable;
import org.orienteer.core.component.table.component.GenericTablePanel;
import org.orienteer.core.model.ODocumentNameModel;
import org.orienteer.core.service.impl.OClassIntrospector;
import org.orienteer.core.widget.AbstractWidget;
import org.orienteer.core.widget.Widget;
import org.orienteer.graph.component.command.CreateEdgeCommand;
import org.orienteer.graph.component.command.DeleteEdgeCommand;
import ru.ydn.wicket.wicketorientdb.behavior.DisableIfDocumentNotSavedBehavior;
import ru.ydn.wicket.wicketorientdb.model.OQueryDataProvider;
import ru.ydn.wicket.wicketorientdb.model.SimpleNamingModel;

@Widget(id="edges", domain="document", order=20, autoEnable=true, selector="V")
public class GraphEdgesWidget
extends AbstractWidget<ODocument> {
    @Inject
    private OClassIntrospector oClassIntrospector;

    public GraphEdgesWidget(String id, IModel<ODocument> model, IModel<ODocument> widgetDocumentModel) {
        super(id, model, widgetDocumentModel);
        IModel modeModel = DisplayMode.VIEW.asModel();
        OQueryDataProvider vertexEdgesDataProvider = new OQueryDataProvider("SELECT expand(bothE()) FROM " + ((ODocument)model.getObject()).getIdentity());
        OClass commonParent = vertexEdgesDataProvider.probeOClass(20);
        if (commonParent == null) {
            commonParent = this.getSchema().getClass("E");
        }
        List columns = this.oClassIntrospector.getColumnsFor(commonParent, true, modeModel);
        commonParent.declaredProperties();
        commonParent.properties();
        columns.add(new AbstractColumn<ODocument, String>((IModel)new SimpleNamingModel((Object)"out"), null){

            public void populateItem(Item<ICellPopulator<ODocument>> components, String s, IModel<ODocument> documentIModel) {
                Model vertex = Model.of((Serializable)((ODocument)((ODocument)documentIModel.getObject()).field("out")));
                components.add(new Component[]{new LinkViewPanel(s, (IModel)vertex)});
            }
        });
        columns.add(new AbstractColumn<ODocument, String>((IModel)new SimpleNamingModel((Object)"in"), null){

            public void populateItem(Item<ICellPopulator<ODocument>> components, String s, IModel<ODocument> documentIModel) {
                Model vertex = Model.of((Serializable)((ODocument)((ODocument)documentIModel.getObject()).field("in")));
                components.add(new Component[]{new LinkViewPanel(s, (IModel)vertex)});
            }
        });
        GenericTablePanel tablePanel = new GenericTablePanel("edges", columns, vertexEdgesDataProvider, 20);
        OrienteerDataTable table = tablePanel.getDataTable();
        table.addCommand(new CreateEdgeCommand((IModel<?>)new ResourceModel("command.create"), (OrienteerDataTable<ODocument, ?>)table, (IModel<ODocument>)this.getModel()).setBootstrapType(BootstrapType.PRIMARY));
        table.addCommand((Command)new EditODocumentsCommand(table, modeModel, commonParent));
        table.addCommand((Command)new SaveODocumentsCommand(table, modeModel));
        table.addCommand((Command)new DeleteEdgeCommand(table, (IModel<ODocument>)this.getModel()));
        this.add(new Component[]{tablePanel});
        this.add(new Behavior[]{DisableIfDocumentNotSavedBehavior.INSTANCE, UpdateOnActionPerformedEventBehavior.INSTANCE_ALL_CONTINUE});
    }

    protected FAIcon newIcon(String id) {
        return new FAIcon(id, FAIconType.arrows_h);
    }

    protected IModel<String> getDefaultTitleModel() {
        return new StringResourceModel("widget.document.edges.title", (IModel)new ODocumentNameModel(this.getModel()));
    }

    protected String getWidgetStyleClass() {
        return "strict";
    }
}

